import "./chunk-LK32TJAX.js";

// node_modules/@algolia/autocomplete-plugin-algolia-insights/node_modules/@algolia/autocomplete-shared/dist/esm/createRef.js
function createRef(initialValue) {
  return {
    current: initialValue
  };
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/node_modules/@algolia/autocomplete-shared/dist/esm/debounce.js
function debounce(fn, time) {
  var timerId = void 0;
  return function() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    if (timerId) {
      clearTimeout(timerId);
    }
    timerId = setTimeout(function() {
      return fn.apply(void 0, args);
    }, time);
  };
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/node_modules/@algolia/autocomplete-shared/dist/esm/isEqual.js
function isPrimitive(obj) {
  return obj !== Object(obj);
}
function isEqual(first, second) {
  if (first === second) {
    return true;
  }
  if (isPrimitive(first) || isPrimitive(second) || typeof first === "function" || typeof second === "function") {
    return first === second;
  }
  if (Object.keys(first).length !== Object.keys(second).length) {
    return false;
  }
  for (var _i = 0, _Object$keys = Object.keys(first); _i < _Object$keys.length; _i++) {
    var key = _Object$keys[_i];
    if (!(key in second)) {
      return false;
    }
    if (!isEqual(first[key], second[key])) {
      return false;
    }
  }
  return true;
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/node_modules/@algolia/autocomplete-shared/dist/esm/noop.js
var noop = function noop2() {
};

// node_modules/@algolia/autocomplete-plugin-algolia-insights/node_modules/@algolia/autocomplete-shared/dist/esm/safelyRunOnBrowser.js
function safelyRunOnBrowser(callback) {
  if (typeof window !== "undefined") {
    return callback({
      window
    });
  }
  return void 0;
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/dist/esm/createClickedEvent.js
function createClickedEvent(_ref) {
  var item = _ref.item, _ref$items = _ref.items, items = _ref$items === void 0 ? [] : _ref$items;
  return {
    index: item.__autocomplete_indexName,
    items: [item],
    positions: [1 + items.findIndex(function(x2) {
      return x2.objectID === item.objectID;
    })],
    queryID: item.__autocomplete_queryID,
    algoliaSource: ["autocomplete"]
  };
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/dist/esm/isModernInsightsClient.js
function _slicedToArray(arr, i2) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i2) || _unsupportedIterableToArray(arr, i2) || _nonIterableRest();
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray(o2, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function _iterableToArrayLimit(arr, i2) {
  var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
  if (null != _i) {
    var _s, _e, _x, _r, _arr = [], _n = true, _d = false;
    try {
      if (_x = (_i = _i.call(arr)).next, 0 === i2) {
        if (Object(_i) !== _i) return;
        _n = false;
      } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i2); _n = true) ;
    } catch (err) {
      _d = true, _e = err;
    } finally {
      try {
        if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return;
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
}
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}
function isModernInsightsClient(client) {
  var _split$map = (client.version || "").split(".").map(Number), _split$map2 = _slicedToArray(_split$map, 2), major = _split$map2[0], minor = _split$map2[1];
  var v3 = major >= 3;
  var v2_4 = major === 2 && minor >= 4;
  var v1_10 = major === 1 && minor >= 10;
  return v3 || v2_4 || v1_10;
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/dist/esm/createSearchInsightsApi.js
var _excluded = ["items"];
var _excluded2 = ["items"];
function _typeof(obj) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof(obj);
}
function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray2(arr) || _nonIterableSpread();
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray2(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray2(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray2(o2, minLen);
}
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray2(arr);
}
function _arrayLikeToArray2(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys(Object(source), true).forEach(function(key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
function _toPrimitive(input, hint) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function chunk(item) {
  var chunkSize = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 20;
  var chunks = [];
  for (var i2 = 0; i2 < item.objectIDs.length; i2 += chunkSize) {
    chunks.push(_objectSpread(_objectSpread({}, item), {}, {
      objectIDs: item.objectIDs.slice(i2, i2 + chunkSize)
    }));
  }
  return chunks;
}
function mapToInsightsParamsApi(params) {
  return params.map(function(_ref) {
    var items = _ref.items, param = _objectWithoutProperties(_ref, _excluded);
    return _objectSpread(_objectSpread({}, param), {}, {
      objectIDs: (items === null || items === void 0 ? void 0 : items.map(function(_ref2) {
        var objectID = _ref2.objectID;
        return objectID;
      })) || param.objectIDs
    });
  });
}
function createSearchInsightsApi(searchInsights) {
  var canSendHeaders = isModernInsightsClient(searchInsights);
  function sendToInsights(method, payloads, items) {
    if (canSendHeaders && typeof items !== "undefined") {
      var _items$0$__autocomple = items[0].__autocomplete_algoliaCredentials, appId = _items$0$__autocomple.appId, apiKey = _items$0$__autocomple.apiKey;
      var headers = {
        "X-Algolia-Application-Id": appId,
        "X-Algolia-API-Key": apiKey
      };
      searchInsights.apply(void 0, [method].concat(_toConsumableArray(payloads), [{
        headers
      }]));
    } else {
      searchInsights.apply(void 0, [method].concat(_toConsumableArray(payloads)));
    }
  }
  return {
    /**
     * Initializes Insights with Algolia credentials.
     */
    init: function init(appId, apiKey) {
      searchInsights("init", {
        appId,
        apiKey
      });
    },
    /**
     * Sets the authenticated user token to attach to events.
     * Unsets the authenticated token by passing `undefined`.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/set-authenticated-user-token/
     */
    setAuthenticatedUserToken: function setAuthenticatedUserToken(authenticatedUserToken) {
      searchInsights("setAuthenticatedUserToken", authenticatedUserToken);
    },
    /**
     * Sets the user token to attach to events.
     */
    setUserToken: function setUserToken(userToken) {
      searchInsights("setUserToken", userToken);
    },
    /**
     * Sends click events to capture a query and its clicked items and positions.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/clicked-object-ids-after-search/
     */
    clickedObjectIDsAfterSearch: function clickedObjectIDsAfterSearch() {
      for (var _len = arguments.length, params = new Array(_len), _key = 0; _key < _len; _key++) {
        params[_key] = arguments[_key];
      }
      if (params.length > 0) {
        sendToInsights("clickedObjectIDsAfterSearch", mapToInsightsParamsApi(params), params[0].items);
      }
    },
    /**
     * Sends click events to capture clicked items.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/clicked-object-ids/
     */
    clickedObjectIDs: function clickedObjectIDs() {
      for (var _len2 = arguments.length, params = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        params[_key2] = arguments[_key2];
      }
      if (params.length > 0) {
        sendToInsights("clickedObjectIDs", mapToInsightsParamsApi(params), params[0].items);
      }
    },
    /**
     * Sends click events to capture the filters a user clicks on.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/clicked-filters/
     */
    clickedFilters: function clickedFilters() {
      for (var _len3 = arguments.length, params = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        params[_key3] = arguments[_key3];
      }
      if (params.length > 0) {
        searchInsights.apply(void 0, ["clickedFilters"].concat(params));
      }
    },
    /**
     * Sends conversion events to capture a query and its clicked items.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/converted-object-ids-after-search/
     */
    convertedObjectIDsAfterSearch: function convertedObjectIDsAfterSearch() {
      for (var _len4 = arguments.length, params = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        params[_key4] = arguments[_key4];
      }
      if (params.length > 0) {
        sendToInsights("convertedObjectIDsAfterSearch", mapToInsightsParamsApi(params), params[0].items);
      }
    },
    /**
     * Sends conversion events to capture clicked items.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/converted-object-ids/
     */
    convertedObjectIDs: function convertedObjectIDs() {
      for (var _len5 = arguments.length, params = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        params[_key5] = arguments[_key5];
      }
      if (params.length > 0) {
        sendToInsights("convertedObjectIDs", mapToInsightsParamsApi(params), params[0].items);
      }
    },
    /**
     * Sends conversion events to capture the filters a user uses when converting.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/converted-filters/
     */
    convertedFilters: function convertedFilters() {
      for (var _len6 = arguments.length, params = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
        params[_key6] = arguments[_key6];
      }
      if (params.length > 0) {
        searchInsights.apply(void 0, ["convertedFilters"].concat(params));
      }
    },
    /**
     * Sends view events to capture clicked items.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/viewed-object-ids/
     */
    viewedObjectIDs: function viewedObjectIDs() {
      for (var _len7 = arguments.length, params = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
        params[_key7] = arguments[_key7];
      }
      if (params.length > 0) {
        params.reduce(function(acc, _ref3) {
          var items = _ref3.items, param = _objectWithoutProperties(_ref3, _excluded2);
          return [].concat(_toConsumableArray(acc), _toConsumableArray(chunk(_objectSpread(_objectSpread({}, param), {}, {
            objectIDs: (items === null || items === void 0 ? void 0 : items.map(function(_ref4) {
              var objectID = _ref4.objectID;
              return objectID;
            })) || param.objectIDs
          })).map(function(payload) {
            return {
              items,
              payload
            };
          })));
        }, []).forEach(function(_ref5) {
          var items = _ref5.items, payload = _ref5.payload;
          return sendToInsights("viewedObjectIDs", [payload], items);
        });
      }
    },
    /**
     * Sends view events to capture the filters a user uses when viewing.
     *
     * @link https://www.algolia.com/doc/api-reference/api-methods/viewed-filters/
     */
    viewedFilters: function viewedFilters() {
      for (var _len8 = arguments.length, params = new Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
        params[_key8] = arguments[_key8];
      }
      if (params.length > 0) {
        searchInsights.apply(void 0, ["viewedFilters"].concat(params));
      }
    }
  };
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/dist/esm/createViewedEvents.js
function createViewedEvents(_ref) {
  var items = _ref.items;
  var itemsByIndexName = items.reduce(function(acc, current) {
    var _acc$current$__autoco;
    acc[current.__autocomplete_indexName] = ((_acc$current$__autoco = acc[current.__autocomplete_indexName]) !== null && _acc$current$__autoco !== void 0 ? _acc$current$__autoco : []).concat(current);
    return acc;
  }, {});
  return Object.keys(itemsByIndexName).map(function(indexName) {
    var items2 = itemsByIndexName[indexName];
    return {
      index: indexName,
      items: items2,
      algoliaSource: ["autocomplete"]
    };
  });
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/dist/esm/isAlgoliaInsightsHit.js
function isAlgoliaInsightsHit(hit) {
  return hit.objectID && hit.__autocomplete_indexName && hit.__autocomplete_queryID;
}

// node_modules/@algolia/autocomplete-plugin-algolia-insights/dist/esm/createAlgoliaInsightsPlugin.js
function _typeof2(obj) {
  "@babel/helpers - typeof";
  return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof2(obj);
}
function _toConsumableArray2(arr) {
  return _arrayWithoutHoles2(arr) || _iterableToArray2(arr) || _unsupportedIterableToArray3(arr) || _nonIterableSpread2();
}
function _nonIterableSpread2() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray3(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray3(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray3(o2, minLen);
}
function _iterableToArray2(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles2(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray3(arr);
}
function _arrayLikeToArray3(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function ownKeys2(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread2(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys2(Object(source), true).forEach(function(key) {
      _defineProperty2(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys2(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty2(obj, key, value) {
  key = _toPropertyKey2(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey2(arg) {
  var key = _toPrimitive2(arg, "string");
  return _typeof2(key) === "symbol" ? key : String(key);
}
function _toPrimitive2(input, hint) {
  if (_typeof2(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof2(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var VIEW_EVENT_DELAY = 400;
var ALGOLIA_INSIGHTS_VERSION = "2.15.0";
var ALGOLIA_INSIGHTS_SRC = "https://cdn.jsdelivr.net/npm/search-insights@".concat(ALGOLIA_INSIGHTS_VERSION, "/dist/search-insights.min.js");
var sendViewedObjectIDs = debounce(function(_ref) {
  var onItemsChange = _ref.onItemsChange, items = _ref.items, insights = _ref.insights, state = _ref.state;
  onItemsChange({
    insights,
    insightsEvents: createViewedEvents({
      items
    }).map(function(event) {
      return _objectSpread2({
        eventName: "Items Viewed"
      }, event);
    }),
    state
  });
}, VIEW_EVENT_DELAY);
function createAlgoliaInsightsPlugin(options) {
  var _getOptions = getOptions(options), providedInsightsClient = _getOptions.insightsClient, insightsInitParams = _getOptions.insightsInitParams, onItemsChange = _getOptions.onItemsChange, onSelectEvent = _getOptions.onSelect, onActiveEvent = _getOptions.onActive, __autocomplete_clickAnalytics = _getOptions.__autocomplete_clickAnalytics;
  var insightsClient = providedInsightsClient;
  if (!providedInsightsClient) {
    safelyRunOnBrowser(function(_ref2) {
      var window2 = _ref2.window;
      var pointer = window2.AlgoliaAnalyticsObject || "aa";
      if (typeof pointer === "string") {
        insightsClient = window2[pointer];
      }
      if (!insightsClient) {
        window2.AlgoliaAnalyticsObject = pointer;
        if (!window2[pointer]) {
          window2[pointer] = function() {
            if (!window2[pointer].queue) {
              window2[pointer].queue = [];
            }
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }
            window2[pointer].queue.push(args);
          };
        }
        window2[pointer].version = ALGOLIA_INSIGHTS_VERSION;
        insightsClient = window2[pointer];
        loadInsights(window2);
      }
    });
  }
  if (!insightsClient) {
    return {};
  }
  if (insightsInitParams) {
    insightsClient("init", _objectSpread2({
      partial: true
    }, insightsInitParams));
  }
  var insights = createSearchInsightsApi(insightsClient);
  var previousItems = createRef([]);
  var debouncedOnStateChange = debounce(function(_ref3) {
    var state = _ref3.state;
    if (!state.isOpen) {
      return;
    }
    var items = state.collections.reduce(function(acc, current) {
      return [].concat(_toConsumableArray2(acc), _toConsumableArray2(current.items));
    }, []).filter(isAlgoliaInsightsHit);
    if (!isEqual(previousItems.current.map(function(x2) {
      return x2.objectID;
    }), items.map(function(x2) {
      return x2.objectID;
    }))) {
      previousItems.current = items;
      if (items.length > 0) {
        sendViewedObjectIDs({
          onItemsChange,
          items,
          insights,
          state
        });
      }
    }
  }, 0);
  return {
    name: "aa.algoliaInsightsPlugin",
    subscribe: function subscribe(_ref4) {
      var setContext = _ref4.setContext, onSelect = _ref4.onSelect, onActive = _ref4.onActive;
      function setInsightsContext(userToken) {
        setContext({
          algoliaInsightsPlugin: {
            __algoliaSearchParameters: _objectSpread2(_objectSpread2({}, __autocomplete_clickAnalytics ? {
              clickAnalytics: true
            } : {}), userToken ? {
              userToken: normalizeUserToken(userToken)
            } : {}),
            insights
          }
        });
      }
      insightsClient("addAlgoliaAgent", "insights-plugin");
      setInsightsContext();
      insightsClient("onUserTokenChange", function(userToken) {
        setInsightsContext(userToken);
      });
      insightsClient("getUserToken", null, function(_error, userToken) {
        setInsightsContext(userToken);
      });
      onSelect(function(_ref5) {
        var item = _ref5.item, state = _ref5.state, event = _ref5.event, source = _ref5.source;
        if (!isAlgoliaInsightsHit(item)) {
          return;
        }
        onSelectEvent({
          state,
          event,
          insights,
          item,
          insightsEvents: [_objectSpread2({
            eventName: "Item Selected"
          }, createClickedEvent({
            item,
            items: source.getItems().filter(isAlgoliaInsightsHit)
          }))]
        });
      });
      onActive(function(_ref6) {
        var item = _ref6.item, source = _ref6.source, state = _ref6.state, event = _ref6.event;
        if (!isAlgoliaInsightsHit(item)) {
          return;
        }
        onActiveEvent({
          state,
          event,
          insights,
          item,
          insightsEvents: [_objectSpread2({
            eventName: "Item Active"
          }, createClickedEvent({
            item,
            items: source.getItems().filter(isAlgoliaInsightsHit)
          }))]
        });
      });
    },
    onStateChange: function onStateChange(_ref7) {
      var state = _ref7.state;
      debouncedOnStateChange({
        state
      });
    },
    __autocomplete_pluginOptions: options
  };
}
function getAlgoliaSources() {
  var _context$algoliaInsig;
  var algoliaSourceBase = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : [];
  var context = arguments.length > 1 ? arguments[1] : void 0;
  return [].concat(_toConsumableArray2(algoliaSourceBase), ["autocomplete-internal"], _toConsumableArray2((_context$algoliaInsig = context.algoliaInsightsPlugin) !== null && _context$algoliaInsig !== void 0 && _context$algoliaInsig.__automaticInsights ? ["autocomplete-automatic"] : []));
}
function getOptions(options) {
  return _objectSpread2({
    onItemsChange: function onItemsChange(_ref8) {
      var insights = _ref8.insights, insightsEvents = _ref8.insightsEvents, state = _ref8.state;
      insights.viewedObjectIDs.apply(insights, _toConsumableArray2(insightsEvents.map(function(event) {
        return _objectSpread2(_objectSpread2({}, event), {}, {
          algoliaSource: getAlgoliaSources(event.algoliaSource, state.context)
        });
      })));
    },
    onSelect: function onSelect(_ref9) {
      var insights = _ref9.insights, insightsEvents = _ref9.insightsEvents, state = _ref9.state;
      insights.clickedObjectIDsAfterSearch.apply(insights, _toConsumableArray2(insightsEvents.map(function(event) {
        return _objectSpread2(_objectSpread2({}, event), {}, {
          algoliaSource: getAlgoliaSources(event.algoliaSource, state.context)
        });
      })));
    },
    onActive: noop,
    __autocomplete_clickAnalytics: true
  }, options);
}
function loadInsights(environment) {
  var errorMessage = "[Autocomplete]: Could not load search-insights.js. Please load it manually following https://alg.li/insights-autocomplete";
  try {
    var script = environment.document.createElement("script");
    script.async = true;
    script.src = ALGOLIA_INSIGHTS_SRC;
    script.onerror = function() {
      console.error(errorMessage);
    };
    document.body.appendChild(script);
  } catch (cause) {
    console.error(errorMessage);
  }
}
function normalizeUserToken(userToken) {
  return typeof userToken === "number" ? userToken.toString() : userToken;
}

// node_modules/@algolia/autocomplete-shared/dist/esm/createRef.js
function createRef2(initialValue) {
  return {
    current: initialValue
  };
}

// node_modules/@algolia/autocomplete-shared/dist/esm/debounce.js
function debounce2(fn, time) {
  var timerId = void 0;
  return function() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    if (timerId) {
      clearTimeout(timerId);
    }
    timerId = setTimeout(function() {
      return fn.apply(void 0, args);
    }, time);
  };
}

// node_modules/@algolia/autocomplete-shared/dist/esm/decycle.js
function _slicedToArray2(arr, i2) {
  return _arrayWithHoles2(arr) || _iterableToArrayLimit2(arr, i2) || _unsupportedIterableToArray4(arr, i2) || _nonIterableRest2();
}
function _nonIterableRest2() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray4(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray4(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray4(o2, minLen);
}
function _arrayLikeToArray4(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function _iterableToArrayLimit2(arr, i2) {
  var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
  if (null != _i) {
    var _s, _e, _x, _r, _arr = [], _n = true, _d = false;
    try {
      if (_x = (_i = _i.call(arr)).next, 0 === i2) {
        if (Object(_i) !== _i) return;
        _n = false;
      } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i2); _n = true) ;
    } catch (err) {
      _d = true, _e = err;
    } finally {
      try {
        if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return;
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
}
function _arrayWithHoles2(arr) {
  if (Array.isArray(arr)) return arr;
}
function _typeof3(obj) {
  "@babel/helpers - typeof";
  return _typeof3 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof3(obj);
}
function decycle(obj) {
  var seen = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : /* @__PURE__ */ new Set();
  if (!obj || _typeof3(obj) !== "object") {
    return obj;
  }
  if (seen.has(obj)) {
    return "[Circular]";
  }
  var newSeen = seen.add(obj);
  if (Array.isArray(obj)) {
    return obj.map(function(x2) {
      return decycle(x2, newSeen);
    });
  }
  return Object.fromEntries(Object.entries(obj).map(function(_ref) {
    var _ref2 = _slicedToArray2(_ref, 2), key = _ref2[0], value = _ref2[1];
    return [key, decycle(value, newSeen)];
  }));
}

// node_modules/@algolia/autocomplete-shared/dist/esm/flatten.js
function flatten(values) {
  return values.reduce(function(a2, b) {
    return a2.concat(b);
  }, []);
}

// node_modules/@algolia/autocomplete-shared/dist/esm/generateAutocompleteId.js
var autocompleteId = 0;
function generateAutocompleteId() {
  return "autocomplete-".concat(autocompleteId++);
}

// node_modules/@algolia/autocomplete-shared/dist/esm/getAttributeValueByPath.js
function getAttributeValueByPath(record, path) {
  return path.reduce(function(current, key) {
    return current && current[key];
  }, record);
}

// node_modules/@algolia/autocomplete-shared/dist/esm/getItemsCount.js
function getItemsCount(state) {
  if (state.collections.length === 0) {
    return 0;
  }
  return state.collections.reduce(function(sum, collection) {
    return sum + collection.items.length;
  }, 0);
}

// node_modules/@algolia/autocomplete-shared/dist/esm/invariant.js
function invariant(condition, message) {
  if (false) {
    return;
  }
  if (!condition) {
    throw new Error("[Autocomplete] ".concat(typeof message === "function" ? message() : message));
  }
}

// node_modules/@algolia/autocomplete-shared/dist/esm/noop.js
var noop3 = function noop4() {
};

// node_modules/@algolia/autocomplete-shared/dist/esm/version.js
var version2 = "1.19.2";

// node_modules/@algolia/autocomplete-shared/dist/esm/userAgents.js
var userAgents = [{
  segment: "autocomplete-core",
  version: version2
}];

// node_modules/@algolia/autocomplete-shared/dist/esm/warn.js
var warnCache = {
  current: {}
};
function warn(condition, message) {
  if (false) {
    return;
  }
  if (condition) {
    return;
  }
  var sanitizedMessage = message.trim();
  var hasAlreadyPrinted = warnCache.current[sanitizedMessage];
  if (!hasAlreadyPrinted) {
    warnCache.current[sanitizedMessage] = true;
    console.warn("[Autocomplete] ".concat(sanitizedMessage));
  }
}

// node_modules/@algolia/autocomplete-core/dist/esm/checkOptions.js
function checkOptions(options) {
  true ? warn(!options.debug, "The `debug` option is meant for development debugging and should not be used in production.") : void 0;
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/createCancelablePromise.js
function createInternalCancelablePromise(promise, initialState) {
  var state = initialState;
  return {
    then: function then(onfulfilled, onrejected) {
      return createInternalCancelablePromise(promise.then(createCallback(onfulfilled, state, promise), createCallback(onrejected, state, promise)), state);
    },
    catch: function _catch(onrejected) {
      return createInternalCancelablePromise(promise.catch(createCallback(onrejected, state, promise)), state);
    },
    finally: function _finally(onfinally) {
      if (onfinally) {
        state.onCancelList.push(onfinally);
      }
      return createInternalCancelablePromise(promise.finally(createCallback(onfinally && function() {
        state.onCancelList = [];
        return onfinally();
      }, state, promise)), state);
    },
    cancel: function cancel() {
      state.isCanceled = true;
      var callbacks = state.onCancelList;
      state.onCancelList = [];
      callbacks.forEach(function(callback) {
        callback();
      });
    },
    isCanceled: function isCanceled() {
      return state.isCanceled === true;
    }
  };
}
function createCancelablePromise(executor) {
  return createInternalCancelablePromise(new Promise(function(resolve2, reject) {
    return executor(resolve2, reject);
  }), {
    isCanceled: false,
    onCancelList: []
  });
}
createCancelablePromise.resolve = function(value) {
  return cancelable(Promise.resolve(value));
};
createCancelablePromise.reject = function(reason) {
  return cancelable(Promise.reject(reason));
};
function cancelable(promise) {
  return createInternalCancelablePromise(promise, {
    isCanceled: false,
    onCancelList: []
  });
}
function createCallback(onResult, state, fallback) {
  if (!onResult) {
    return fallback;
  }
  return function callback(arg) {
    if (state.isCanceled) {
      return arg;
    }
    return onResult(arg);
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/createCancelablePromiseList.js
var _hasWaitPromiseResolved = true;
var _waitPromise;
function createCancelablePromiseList() {
  var list = [];
  return {
    add: function add(cancelablePromise) {
      list.push(cancelablePromise);
      return cancelablePromise.finally(function() {
        list = list.filter(function(item) {
          return item !== cancelablePromise;
        });
      });
    },
    cancelAll: function cancelAll() {
      list.forEach(function(promise) {
        return promise.cancel();
      });
    },
    isEmpty: function isEmpty() {
      return list.length === 0;
    },
    wait: function wait(timeout) {
      if (!_hasWaitPromiseResolved) {
        return _waitPromise;
      }
      _hasWaitPromiseResolved = false;
      _waitPromise = !timeout ? Promise.all(list) : Promise.race([Promise.all(list), new Promise(function(resolve2) {
        return setTimeout(resolve2, timeout);
      })]);
      return _waitPromise.then(function() {
        _hasWaitPromiseResolved = true;
      });
    }
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/createConcurrentSafePromise.js
function createConcurrentSafePromise() {
  var basePromiseId = -1;
  var latestResolvedId = -1;
  var latestResolvedValue = void 0;
  return function runConcurrentSafePromise2(promise) {
    basePromiseId++;
    var currentPromiseId = basePromiseId;
    return Promise.resolve(promise).then(function(x2) {
      if (latestResolvedValue && currentPromiseId < latestResolvedId) {
        return latestResolvedValue;
      }
      latestResolvedId = currentPromiseId;
      latestResolvedValue = x2;
      return x2;
    });
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/getNextActiveItemId.js
function getNextActiveItemId(moveAmount, baseIndex, itemCount, defaultActiveItemId) {
  if (!itemCount) {
    return null;
  }
  if (moveAmount < 0 && (baseIndex === null || defaultActiveItemId !== null && baseIndex === 0)) {
    return itemCount + moveAmount;
  }
  var numericIndex = (baseIndex === null ? -1 : baseIndex) + moveAmount;
  if (numericIndex <= -1 || numericIndex >= itemCount) {
    return defaultActiveItemId === null ? null : 0;
  }
  return numericIndex;
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/getNormalizedSources.js
function ownKeys3(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread3(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys3(Object(source), true).forEach(function(key) {
      _defineProperty3(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys3(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty3(obj, key, value) {
  key = _toPropertyKey3(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey3(arg) {
  var key = _toPrimitive3(arg, "string");
  return _typeof4(key) === "symbol" ? key : String(key);
}
function _toPrimitive3(input, hint) {
  if (_typeof4(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof4(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _typeof4(obj) {
  "@babel/helpers - typeof";
  return _typeof4 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof4(obj);
}
function getNormalizedSources(getSources, params) {
  var seenSourceIds = [];
  return Promise.resolve(getSources(params)).then(function(sources) {
    invariant(Array.isArray(sources), function() {
      return "The `getSources` function must return an array of sources but returned type ".concat(JSON.stringify(_typeof4(sources)), ":\n\n").concat(JSON.stringify(decycle(sources), null, 2));
    });
    return Promise.all(sources.filter(function(maybeSource) {
      return Boolean(maybeSource);
    }).map(function(source) {
      invariant(typeof source.sourceId === "string", "A source must provide a `sourceId` string.");
      if (seenSourceIds.includes(source.sourceId)) {
        throw new Error("[Autocomplete] The `sourceId` ".concat(JSON.stringify(source.sourceId), " is not unique."));
      }
      seenSourceIds.push(source.sourceId);
      var defaultSource = {
        getItemInputValue: function getItemInputValue(_ref) {
          var state = _ref.state;
          return state.query;
        },
        getItemUrl: function getItemUrl() {
          return void 0;
        },
        onSelect: function onSelect(_ref2) {
          var setIsOpen = _ref2.setIsOpen;
          setIsOpen(false);
        },
        onActive: noop3,
        onResolve: noop3
      };
      Object.keys(defaultSource).forEach(function(key) {
        defaultSource[key].__default = true;
      });
      var normalizedSource = _objectSpread3(_objectSpread3({}, defaultSource), source);
      return Promise.resolve(normalizedSource);
    }));
  });
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/getPluginSubmitPromise.js
function _createForOfIteratorHelper(o2, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o2[Symbol.iterator] || o2["@@iterator"];
  if (!it) {
    if (Array.isArray(o2) || (it = _unsupportedIterableToArray5(o2)) || allowArrayLike && o2 && typeof o2.length === "number") {
      if (it) o2 = it;
      var i2 = 0;
      var F2 = function F3() {
      };
      return { s: F2, n: function n3() {
        if (i2 >= o2.length) return { done: true };
        return { done: false, value: o2[i2++] };
      }, e: function e2(_e) {
        throw _e;
      }, f: F2 };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true, didErr = false, err;
  return { s: function s2() {
    it = it.call(o2);
  }, n: function n3() {
    var step = it.next();
    normalCompletion = step.done;
    return step;
  }, e: function e2(_e2) {
    didErr = true;
    err = _e2;
  }, f: function f2() {
    try {
      if (!normalCompletion && it.return != null) it.return();
    } finally {
      if (didErr) throw err;
    }
  } };
}
function _unsupportedIterableToArray5(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray5(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray5(o2, minLen);
}
function _arrayLikeToArray5(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
var getPluginSubmitPromise = function getPluginSubmitPromise2(plugins, pendingRequests) {
  var waitUntilComplete = false;
  var timeouts = [];
  var _iterator = _createForOfIteratorHelper(plugins), _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done; ) {
      var _plugin$__autocomplet, _plugin$__autocomplet2, _plugin$__autocomplet3;
      var plugin = _step.value;
      var value = (_plugin$__autocomplet = plugin.__autocomplete_pluginOptions) === null || _plugin$__autocomplet === void 0 ? void 0 : (_plugin$__autocomplet2 = (_plugin$__autocomplet3 = _plugin$__autocomplet).awaitSubmit) === null || _plugin$__autocomplet2 === void 0 ? void 0 : _plugin$__autocomplet2.call(_plugin$__autocomplet3);
      if (typeof value === "number") {
        timeouts.push(value);
      } else if (value === true) {
        waitUntilComplete = true;
        break;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  if (waitUntilComplete) {
    return pendingRequests.wait();
  } else if (timeouts.length > 0) {
    return pendingRequests.wait(Math.max.apply(Math, timeouts));
  }
  return void 0;
};

// node_modules/@algolia/autocomplete-core/dist/esm/utils/getActiveItem.js
function getCollectionFromActiveItemId(state) {
  var accumulatedCollectionsCount = state.collections.map(function(collections) {
    return collections.items.length;
  }).reduce(function(acc, collectionsCount, index) {
    var previousValue = acc[index - 1] || 0;
    var nextValue = previousValue + collectionsCount;
    acc.push(nextValue);
    return acc;
  }, []);
  var collectionIndex = accumulatedCollectionsCount.reduce(function(acc, current) {
    if (current <= state.activeItemId) {
      return acc + 1;
    }
    return acc;
  }, 0);
  return state.collections[collectionIndex];
}
function getRelativeActiveItemId(_ref) {
  var state = _ref.state, collection = _ref.collection;
  var isOffsetFound = false;
  var counter = 0;
  var previousItemsOffset = 0;
  while (isOffsetFound === false) {
    var currentCollection = state.collections[counter];
    if (currentCollection === collection) {
      isOffsetFound = true;
      break;
    }
    previousItemsOffset += currentCollection.items.length;
    counter++;
  }
  return state.activeItemId - previousItemsOffset;
}
function getActiveItem(state) {
  var collection = getCollectionFromActiveItemId(state);
  if (!collection) {
    return null;
  }
  var item = collection.items[getRelativeActiveItemId({
    state,
    collection
  })];
  var source = collection.source;
  var itemInputValue = source.getItemInputValue({
    item,
    state
  });
  var itemUrl = source.getItemUrl({
    item,
    state
  });
  return {
    item,
    itemInputValue,
    itemUrl,
    source
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/getAutocompleteElementId.js
function getAutocompleteElementId(autocompleteInstanceId, elementId, source) {
  return [autocompleteInstanceId, source === null || source === void 0 ? void 0 : source.sourceId, elementId].filter(Boolean).join("-").replace(/\s/g, "");
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/isOrContainsNode.js
function isOrContainsNode(parent, child) {
  return parent === child || parent.contains(child);
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/isSamsung.js
var regex = /((gt|sm)-|galaxy nexus)|samsung[- ]|samsungbrowser/i;
function isSamsung(userAgent) {
  return Boolean(userAgent && userAgent.match(regex));
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/mapToAlgoliaResponse.js
function mapToAlgoliaResponse(rawResults) {
  return {
    results: rawResults,
    hits: rawResults.map(function(result) {
      return result.hits;
    }).filter(Boolean),
    facetHits: rawResults.map(function(result) {
      var _facetHits;
      return (_facetHits = result.facetHits) === null || _facetHits === void 0 ? void 0 : _facetHits.map(function(facetHit) {
        return {
          label: facetHit.value,
          count: facetHit.count,
          _highlightResult: {
            label: {
              value: facetHit.highlighted
            }
          }
        };
      });
    }).filter(Boolean)
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/utils/getNativeEvent.js
function getNativeEvent(event) {
  return event.nativeEvent || event;
}

// node_modules/@algolia/autocomplete-core/dist/esm/createStore.js
function _typeof5(obj) {
  "@babel/helpers - typeof";
  return _typeof5 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof5(obj);
}
function ownKeys4(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread4(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys4(Object(source), true).forEach(function(key) {
      _defineProperty4(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys4(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty4(obj, key, value) {
  key = _toPropertyKey4(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey4(arg) {
  var key = _toPrimitive4(arg, "string");
  return _typeof5(key) === "symbol" ? key : String(key);
}
function _toPrimitive4(input, hint) {
  if (_typeof5(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof5(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function createStore(reducer, props, onStoreStateChange) {
  var state = props.initialState;
  return {
    getState: function getState() {
      return state;
    },
    dispatch: function dispatch(action, payload) {
      var prevState = _objectSpread4({}, state);
      state = reducer(state, {
        type: action,
        props,
        payload
      });
      onStoreStateChange({
        state,
        prevState
      });
    },
    pendingRequests: createCancelablePromiseList()
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/getAutocompleteSetters.js
function _typeof6(obj) {
  "@babel/helpers - typeof";
  return _typeof6 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof6(obj);
}
function ownKeys5(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread5(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys5(Object(source), true).forEach(function(key) {
      _defineProperty5(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys5(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty5(obj, key, value) {
  key = _toPropertyKey5(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey5(arg) {
  var key = _toPrimitive5(arg, "string");
  return _typeof6(key) === "symbol" ? key : String(key);
}
function _toPrimitive5(input, hint) {
  if (_typeof6(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof6(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function getAutocompleteSetters(_ref) {
  var store = _ref.store;
  var setActiveItemId = function setActiveItemId2(value) {
    store.dispatch("setActiveItemId", value);
  };
  var setQuery = function setQuery2(value) {
    store.dispatch("setQuery", value);
  };
  var setCollections = function setCollections2(rawValue) {
    var baseItemId = 0;
    var value = rawValue.map(function(collection) {
      return _objectSpread5(_objectSpread5({}, collection), {}, {
        // We flatten the stored items to support calling `getAlgoliaResults`
        // from the source itself.
        items: flatten(collection.items).map(function(item) {
          return _objectSpread5(_objectSpread5({}, item), {}, {
            __autocomplete_id: baseItemId++
          });
        })
      });
    });
    store.dispatch("setCollections", value);
  };
  var setIsOpen = function setIsOpen2(value) {
    store.dispatch("setIsOpen", value);
  };
  var setStatus = function setStatus2(value) {
    store.dispatch("setStatus", value);
  };
  var setContext = function setContext2(value) {
    store.dispatch("setContext", value);
  };
  return {
    setActiveItemId,
    setQuery,
    setCollections,
    setIsOpen,
    setStatus,
    setContext
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/getDefaultProps.js
function _typeof7(obj) {
  "@babel/helpers - typeof";
  return _typeof7 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof7(obj);
}
function _toConsumableArray3(arr) {
  return _arrayWithoutHoles3(arr) || _iterableToArray3(arr) || _unsupportedIterableToArray6(arr) || _nonIterableSpread3();
}
function _nonIterableSpread3() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray6(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray6(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray6(o2, minLen);
}
function _iterableToArray3(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles3(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray6(arr);
}
function _arrayLikeToArray6(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function ownKeys6(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread6(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys6(Object(source), true).forEach(function(key) {
      _defineProperty6(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys6(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty6(obj, key, value) {
  key = _toPropertyKey6(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey6(arg) {
  var key = _toPrimitive6(arg, "string");
  return _typeof7(key) === "symbol" ? key : String(key);
}
function _toPrimitive6(input, hint) {
  if (_typeof7(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof7(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function getDefaultProps(props, pluginSubscribers) {
  var _props$id;
  var environment = typeof window !== "undefined" ? window : {};
  var plugins = props.plugins || [];
  return _objectSpread6(_objectSpread6({
    debug: false,
    openOnFocus: false,
    enterKeyHint: void 0,
    ignoreCompositionEvents: false,
    placeholder: "",
    autoFocus: false,
    defaultActiveItemId: null,
    stallThreshold: 300,
    insights: void 0,
    environment,
    shouldPanelOpen: function shouldPanelOpen(_ref) {
      var state = _ref.state;
      return getItemsCount(state) > 0;
    },
    reshape: function reshape2(_ref2) {
      var sources = _ref2.sources;
      return sources;
    }
  }, props), {}, {
    // Since `generateAutocompleteId` triggers a side effect (it increments
    // an internal counter), we don't want to execute it if unnecessary.
    id: (_props$id = props.id) !== null && _props$id !== void 0 ? _props$id : generateAutocompleteId(),
    plugins,
    // The following props need to be deeply defaulted.
    initialState: _objectSpread6({
      activeItemId: null,
      query: "",
      completion: null,
      collections: [],
      isOpen: false,
      status: "idle",
      context: {}
    }, props.initialState),
    onStateChange: function onStateChange(params) {
      var _props$onStateChange;
      (_props$onStateChange = props.onStateChange) === null || _props$onStateChange === void 0 ? void 0 : _props$onStateChange.call(props, params);
      plugins.forEach(function(x2) {
        var _x$onStateChange;
        return (_x$onStateChange = x2.onStateChange) === null || _x$onStateChange === void 0 ? void 0 : _x$onStateChange.call(x2, params);
      });
    },
    onSubmit: function onSubmit(params) {
      var _props$onSubmit;
      (_props$onSubmit = props.onSubmit) === null || _props$onSubmit === void 0 ? void 0 : _props$onSubmit.call(props, params);
      plugins.forEach(function(x2) {
        var _x$onSubmit;
        return (_x$onSubmit = x2.onSubmit) === null || _x$onSubmit === void 0 ? void 0 : _x$onSubmit.call(x2, params);
      });
    },
    onReset: function onReset(params) {
      var _props$onReset;
      (_props$onReset = props.onReset) === null || _props$onReset === void 0 ? void 0 : _props$onReset.call(props, params);
      plugins.forEach(function(x2) {
        var _x$onReset;
        return (_x$onReset = x2.onReset) === null || _x$onReset === void 0 ? void 0 : _x$onReset.call(x2, params);
      });
    },
    getSources: function getSources(params) {
      return Promise.all([].concat(_toConsumableArray3(plugins.map(function(plugin) {
        return plugin.getSources;
      })), [props.getSources]).filter(Boolean).map(function(getSources2) {
        return getNormalizedSources(getSources2, params);
      })).then(function(nested) {
        return flatten(nested);
      }).then(function(sources) {
        return sources.map(function(source) {
          return _objectSpread6(_objectSpread6({}, source), {}, {
            onSelect: function onSelect(params2) {
              source.onSelect(params2);
              pluginSubscribers.forEach(function(x2) {
                var _x$onSelect;
                return (_x$onSelect = x2.onSelect) === null || _x$onSelect === void 0 ? void 0 : _x$onSelect.call(x2, params2);
              });
            },
            onActive: function onActive(params2) {
              source.onActive(params2);
              pluginSubscribers.forEach(function(x2) {
                var _x$onActive;
                return (_x$onActive = x2.onActive) === null || _x$onActive === void 0 ? void 0 : _x$onActive.call(x2, params2);
              });
            },
            onResolve: function onResolve(params2) {
              source.onResolve(params2);
              pluginSubscribers.forEach(function(x2) {
                var _x$onResolve;
                return (_x$onResolve = x2.onResolve) === null || _x$onResolve === void 0 ? void 0 : _x$onResolve.call(x2, params2);
              });
            }
          });
        });
      });
    },
    navigator: _objectSpread6({
      navigate: function navigate(_ref3) {
        var itemUrl = _ref3.itemUrl;
        environment.location.assign(itemUrl);
      },
      navigateNewTab: function navigateNewTab(_ref4) {
        var itemUrl = _ref4.itemUrl;
        var windowReference = environment.open(itemUrl, "_blank", "noopener");
        windowReference === null || windowReference === void 0 ? void 0 : windowReference.focus();
      },
      navigateNewWindow: function navigateNewWindow(_ref5) {
        var itemUrl = _ref5.itemUrl;
        environment.open(itemUrl, "_blank", "noopener");
      }
    }, props.navigator)
  });
}

// node_modules/@algolia/autocomplete-core/dist/esm/reshape.js
function _typeof8(obj) {
  "@babel/helpers - typeof";
  return _typeof8 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof8(obj);
}
function ownKeys7(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread7(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys7(Object(source), true).forEach(function(key) {
      _defineProperty7(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys7(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty7(obj, key, value) {
  key = _toPropertyKey7(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey7(arg) {
  var key = _toPrimitive7(arg, "string");
  return _typeof8(key) === "symbol" ? key : String(key);
}
function _toPrimitive7(input, hint) {
  if (_typeof8(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof8(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function reshape(_ref) {
  var collections = _ref.collections, props = _ref.props, state = _ref.state;
  var originalSourcesBySourceId = collections.reduce(function(acc, collection) {
    return _objectSpread7(_objectSpread7({}, acc), {}, _defineProperty7({}, collection.source.sourceId, _objectSpread7(_objectSpread7({}, collection.source), {}, {
      getItems: function getItems() {
        return flatten(collection.items);
      }
    })));
  }, {});
  var _props$plugins$reduce = props.plugins.reduce(function(acc, plugin) {
    if (plugin.reshape) {
      return plugin.reshape(acc);
    }
    return acc;
  }, {
    sourcesBySourceId: originalSourcesBySourceId,
    state
  }), sourcesBySourceId = _props$plugins$reduce.sourcesBySourceId;
  var reshapeSources = props.reshape({
    sourcesBySourceId,
    sources: Object.values(sourcesBySourceId),
    state
  });
  return flatten(reshapeSources).filter(Boolean).map(function(source) {
    return {
      source,
      items: source.getItems()
    };
  });
}

// node_modules/@algolia/autocomplete-core/dist/esm/resolve.js
function _typeof9(obj) {
  "@babel/helpers - typeof";
  return _typeof9 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof9(obj);
}
function ownKeys8(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread8(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys8(Object(source), true).forEach(function(key) {
      _defineProperty8(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys8(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty8(obj, key, value) {
  key = _toPropertyKey8(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey8(arg) {
  var key = _toPrimitive8(arg, "string");
  return _typeof9(key) === "symbol" ? key : String(key);
}
function _toPrimitive8(input, hint) {
  if (_typeof9(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof9(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toConsumableArray4(arr) {
  return _arrayWithoutHoles4(arr) || _iterableToArray4(arr) || _unsupportedIterableToArray7(arr) || _nonIterableSpread4();
}
function _nonIterableSpread4() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray7(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray7(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray7(o2, minLen);
}
function _iterableToArray4(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles4(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray7(arr);
}
function _arrayLikeToArray7(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function isDescription(item) {
  return Boolean(item.execute);
}
function isRequesterDescription(description) {
  return Boolean(description === null || description === void 0 ? void 0 : description.execute);
}
function preResolve(itemsOrDescription, sourceId, state) {
  if (isRequesterDescription(itemsOrDescription)) {
    var contextParameters = itemsOrDescription.requesterId === "algolia" ? Object.assign.apply(Object, [{}].concat(_toConsumableArray4(Object.keys(state.context).map(function(key) {
      var _state$context$key;
      return (_state$context$key = state.context[key]) === null || _state$context$key === void 0 ? void 0 : _state$context$key.__algoliaSearchParameters;
    })))) : {};
    return _objectSpread8(_objectSpread8({}, itemsOrDescription), {}, {
      requests: itemsOrDescription.queries.map(function(query) {
        return {
          query: itemsOrDescription.requesterId === "algolia" ? _objectSpread8(_objectSpread8({}, query), {}, {
            params: _objectSpread8(_objectSpread8({}, contextParameters), query.params)
          }) : query,
          sourceId,
          transformResponse: itemsOrDescription.transformResponse
        };
      })
    });
  }
  return {
    items: itemsOrDescription,
    sourceId
  };
}
function resolve(items) {
  var packed = items.reduce(function(acc, current) {
    if (!isDescription(current)) {
      acc.push(current);
      return acc;
    }
    var searchClient = current.searchClient, execute = current.execute, requesterId = current.requesterId, requests = current.requests;
    var container = acc.find(function(item) {
      return isDescription(current) && isDescription(item) && item.searchClient === searchClient && Boolean(requesterId) && item.requesterId === requesterId;
    });
    if (container) {
      var _container$items;
      (_container$items = container.items).push.apply(_container$items, _toConsumableArray4(requests));
    } else {
      var request = {
        execute,
        requesterId,
        items: requests,
        searchClient
      };
      acc.push(request);
    }
    return acc;
  }, []);
  var values = packed.map(function(maybeDescription) {
    if (!isDescription(maybeDescription)) {
      return Promise.resolve(maybeDescription);
    }
    var _ref = maybeDescription, execute = _ref.execute, items2 = _ref.items, searchClient = _ref.searchClient;
    return execute({
      searchClient,
      requests: items2
    });
  });
  return Promise.all(values).then(function(responses) {
    return flatten(responses);
  });
}
function postResolve(responses, sources, store) {
  return sources.map(function(source) {
    var matches = responses.filter(function(response) {
      return response.sourceId === source.sourceId;
    });
    var results = matches.map(function(_ref2) {
      var items2 = _ref2.items;
      return items2;
    });
    var transform = matches[0].transformResponse;
    var items = transform ? transform(mapToAlgoliaResponse(results)) : results;
    source.onResolve({
      source,
      results,
      items,
      state: store.getState()
    });
    invariant(Array.isArray(items), function() {
      return 'The `getItems` function from source "'.concat(source.sourceId, '" must return an array of items but returned type ').concat(JSON.stringify(_typeof9(items)), ":\n\n").concat(JSON.stringify(decycle(items), null, 2), ".\n\nSee: https://www.algolia.com/doc/ui-libraries/autocomplete/core-concepts/sources/#param-getitems");
    });
    invariant(items.every(Boolean), 'The `getItems` function from source "'.concat(source.sourceId, '" must return an array of items but returned ').concat(JSON.stringify(void 0), ".\n\nDid you forget to return items?\n\nSee: https://www.algolia.com/doc/ui-libraries/autocomplete/core-concepts/sources/#param-getitems"));
    return {
      source,
      items
    };
  });
}

// node_modules/@algolia/autocomplete-core/dist/esm/onInput.js
function _typeof10(obj) {
  "@babel/helpers - typeof";
  return _typeof10 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof10(obj);
}
var _excluded3 = ["event", "nextState", "props", "query", "refresh", "store"];
function ownKeys9(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread9(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys9(Object(source), true).forEach(function(key) {
      _defineProperty9(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys9(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty9(obj, key, value) {
  key = _toPropertyKey9(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey9(arg) {
  var key = _toPrimitive9(arg, "string");
  return _typeof10(key) === "symbol" ? key : String(key);
}
function _toPrimitive9(input, hint) {
  if (_typeof10(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof10(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _objectWithoutProperties2(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose2(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose2(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
var lastStalledId = null;
var runConcurrentSafePromise = createConcurrentSafePromise();
function onInput(_ref) {
  var event = _ref.event, _ref$nextState = _ref.nextState, nextState = _ref$nextState === void 0 ? {} : _ref$nextState, props = _ref.props, query = _ref.query, refresh = _ref.refresh, store = _ref.store, setters = _objectWithoutProperties2(_ref, _excluded3);
  if (lastStalledId) {
    props.environment.clearTimeout(lastStalledId);
  }
  var setCollections = setters.setCollections, setIsOpen = setters.setIsOpen, setQuery = setters.setQuery, setActiveItemId = setters.setActiveItemId, setStatus = setters.setStatus, setContext = setters.setContext;
  setQuery(query);
  setActiveItemId(props.defaultActiveItemId);
  if (!query && props.openOnFocus === false) {
    var _nextState$isOpen;
    var collections = store.getState().collections.map(function(collection) {
      return _objectSpread9(_objectSpread9({}, collection), {}, {
        items: []
      });
    });
    setStatus("idle");
    setCollections(collections);
    setIsOpen((_nextState$isOpen = nextState.isOpen) !== null && _nextState$isOpen !== void 0 ? _nextState$isOpen : props.shouldPanelOpen({
      state: store.getState()
    }));
    var _request = cancelable(runConcurrentSafePromise(collections).then(function() {
      return Promise.resolve();
    }));
    return store.pendingRequests.add(_request);
  }
  setStatus("loading");
  lastStalledId = props.environment.setTimeout(function() {
    setStatus("stalled");
  }, props.stallThreshold);
  var request = cancelable(runConcurrentSafePromise(props.getSources(_objectSpread9({
    query,
    refresh,
    state: store.getState()
  }, setters)).then(function(sources) {
    return Promise.all(sources.map(function(source) {
      return Promise.resolve(source.getItems(_objectSpread9({
        query,
        refresh,
        state: store.getState()
      }, setters))).then(function(itemsOrDescription) {
        return preResolve(itemsOrDescription, source.sourceId, store.getState());
      });
    })).then(resolve).then(function(responses) {
      var __automaticInsights = responses.some(function(_ref2) {
        var items = _ref2.items;
        return isSearchResponseWithAutomaticInsightsFlag(items);
      });
      if (__automaticInsights) {
        var _store$getState$conte;
        setContext({
          algoliaInsightsPlugin: _objectSpread9(_objectSpread9({}, ((_store$getState$conte = store.getState().context) === null || _store$getState$conte === void 0 ? void 0 : _store$getState$conte.algoliaInsightsPlugin) || {}), {}, {
            __automaticInsights
          })
        });
      }
      return postResolve(responses, sources, store);
    }).then(function(collections2) {
      return reshape({
        collections: collections2,
        props,
        state: store.getState()
      });
    });
  }))).then(function(collections2) {
    var _nextState$isOpen2;
    setStatus("idle");
    setCollections(collections2);
    var isPanelOpen = props.shouldPanelOpen({
      state: store.getState()
    });
    setIsOpen((_nextState$isOpen2 = nextState.isOpen) !== null && _nextState$isOpen2 !== void 0 ? _nextState$isOpen2 : props.openOnFocus && !query && isPanelOpen || isPanelOpen);
    var highlightedItem = getActiveItem(store.getState());
    if (store.getState().activeItemId !== null && highlightedItem) {
      var item = highlightedItem.item, itemInputValue = highlightedItem.itemInputValue, itemUrl = highlightedItem.itemUrl, source = highlightedItem.source;
      source.onActive(_objectSpread9({
        event,
        item,
        itemInputValue,
        itemUrl,
        refresh,
        source,
        state: store.getState()
      }, setters));
    }
  }).finally(function() {
    setStatus("idle");
    if (lastStalledId) {
      props.environment.clearTimeout(lastStalledId);
    }
  });
  return store.pendingRequests.add(request);
}
function isSearchResponseWithAutomaticInsightsFlag(items) {
  return !Array.isArray(items) && Boolean(items === null || items === void 0 ? void 0 : items._automaticInsights);
}

// node_modules/@algolia/autocomplete-core/dist/esm/onKeyDown.js
function _typeof11(obj) {
  "@babel/helpers - typeof";
  return _typeof11 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof11(obj);
}
var _excluded4 = ["event", "props", "refresh", "store"];
function ownKeys10(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread10(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys10(Object(source), true).forEach(function(key) {
      _defineProperty10(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys10(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty10(obj, key, value) {
  key = _toPropertyKey10(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey10(arg) {
  var key = _toPrimitive10(arg, "string");
  return _typeof11(key) === "symbol" ? key : String(key);
}
function _toPrimitive10(input, hint) {
  if (_typeof11(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof11(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _objectWithoutProperties3(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose3(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose3(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function onKeyDown(_ref) {
  var event = _ref.event, props = _ref.props, refresh = _ref.refresh, store = _ref.store, setters = _objectWithoutProperties3(_ref, _excluded4);
  if (event.key === "ArrowUp" || event.key === "ArrowDown") {
    var triggerScrollIntoView = function triggerScrollIntoView2() {
      var highlightedItem = getActiveItem(store.getState());
      var nodeItem = props.environment.document.getElementById(getAutocompleteElementId(props.id, "item-".concat(store.getState().activeItemId), highlightedItem === null || highlightedItem === void 0 ? void 0 : highlightedItem.source));
      if (nodeItem) {
        if (nodeItem.scrollIntoViewIfNeeded) {
          nodeItem.scrollIntoViewIfNeeded(false);
        } else {
          nodeItem.scrollIntoView(false);
        }
      }
    };
    var triggerOnActive = function triggerOnActive2() {
      var highlightedItem = getActiveItem(store.getState());
      if (store.getState().activeItemId !== null && highlightedItem) {
        var item2 = highlightedItem.item, itemInputValue2 = highlightedItem.itemInputValue, itemUrl2 = highlightedItem.itemUrl, source2 = highlightedItem.source;
        source2.onActive(_objectSpread10({
          event,
          item: item2,
          itemInputValue: itemInputValue2,
          itemUrl: itemUrl2,
          refresh,
          source: source2,
          state: store.getState()
        }, setters));
      }
    };
    event.preventDefault();
    if (store.getState().isOpen === false && (props.openOnFocus || Boolean(store.getState().query))) {
      onInput(_objectSpread10({
        event,
        props,
        query: store.getState().query,
        refresh,
        store
      }, setters)).then(function() {
        store.dispatch(event.key, {
          nextActiveItemId: props.defaultActiveItemId
        });
        triggerOnActive();
        setTimeout(triggerScrollIntoView, 0);
      });
    } else {
      store.dispatch(event.key, {});
      triggerOnActive();
      triggerScrollIntoView();
    }
  } else if (event.key === "Escape") {
    event.preventDefault();
    store.dispatch(event.key, null);
    store.pendingRequests.cancelAll();
  } else if (event.key === "Tab") {
    store.dispatch("blur", null);
    store.pendingRequests.cancelAll();
  } else if (event.key === "Enter") {
    if (store.getState().activeItemId === null || store.getState().collections.every(function(collection) {
      return collection.items.length === 0;
    })) {
      var waitForSubmit = getPluginSubmitPromise(props.plugins, store.pendingRequests);
      if (waitForSubmit !== void 0) {
        waitForSubmit.then(store.pendingRequests.cancelAll);
      } else if (!props.debug) {
        store.pendingRequests.cancelAll();
      }
      return;
    }
    event.preventDefault();
    var _ref2 = getActiveItem(store.getState()), item = _ref2.item, itemInputValue = _ref2.itemInputValue, itemUrl = _ref2.itemUrl, source = _ref2.source;
    if (event.metaKey || event.ctrlKey) {
      if (itemUrl !== void 0) {
        source.onSelect(_objectSpread10({
          event,
          item,
          itemInputValue,
          itemUrl,
          refresh,
          source,
          state: store.getState()
        }, setters));
        props.navigator.navigateNewTab({
          itemUrl,
          item,
          state: store.getState()
        });
      }
    } else if (event.shiftKey) {
      if (itemUrl !== void 0) {
        source.onSelect(_objectSpread10({
          event,
          item,
          itemInputValue,
          itemUrl,
          refresh,
          source,
          state: store.getState()
        }, setters));
        props.navigator.navigateNewWindow({
          itemUrl,
          item,
          state: store.getState()
        });
      }
    } else if (event.altKey) {
    } else {
      if (itemUrl !== void 0) {
        source.onSelect(_objectSpread10({
          event,
          item,
          itemInputValue,
          itemUrl,
          refresh,
          source,
          state: store.getState()
        }, setters));
        props.navigator.navigate({
          itemUrl,
          item,
          state: store.getState()
        });
        return;
      }
      onInput(_objectSpread10({
        event,
        nextState: {
          isOpen: false
        },
        props,
        query: itemInputValue,
        refresh,
        store
      }, setters)).then(function() {
        source.onSelect(_objectSpread10({
          event,
          item,
          itemInputValue,
          itemUrl,
          refresh,
          source,
          state: store.getState()
        }, setters));
      });
    }
  }
}

// node_modules/@algolia/autocomplete-core/dist/esm/getPropGetters.js
function _typeof12(obj) {
  "@babel/helpers - typeof";
  return _typeof12 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof12(obj);
}
var _excluded5 = ["props", "refresh", "store"];
var _excluded22 = ["inputElement", "formElement", "panelElement"];
var _excluded32 = ["inputElement"];
var _excluded42 = ["inputElement", "maxLength"];
var _excluded52 = ["source"];
var _excluded6 = ["item", "source"];
function ownKeys11(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread11(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys11(Object(source), true).forEach(function(key) {
      _defineProperty11(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys11(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty11(obj, key, value) {
  key = _toPropertyKey11(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey11(arg) {
  var key = _toPrimitive11(arg, "string");
  return _typeof12(key) === "symbol" ? key : String(key);
}
function _toPrimitive11(input, hint) {
  if (_typeof12(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof12(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _objectWithoutProperties4(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose4(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose4(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function getPropGetters(_ref) {
  var props = _ref.props, refresh = _ref.refresh, store = _ref.store, setters = _objectWithoutProperties4(_ref, _excluded5);
  var getEnvironmentProps = function getEnvironmentProps2(providedProps) {
    var inputElement = providedProps.inputElement, formElement = providedProps.formElement, panelElement = providedProps.panelElement, rest = _objectWithoutProperties4(providedProps, _excluded22);
    function onMouseDownOrTouchStart(event) {
      var isAutocompleteInteraction = store.getState().isOpen || !store.pendingRequests.isEmpty();
      if (!isAutocompleteInteraction || event.target === inputElement) {
        return;
      }
      var isTargetWithinAutocomplete = [formElement, panelElement].some(function(contextNode) {
        return isOrContainsNode(contextNode, event.target);
      });
      if (isTargetWithinAutocomplete === false) {
        store.dispatch("blur", null);
        if (!props.debug) {
          store.pendingRequests.cancelAll();
        }
      }
    }
    return _objectSpread11({
      // We do not rely on the native `blur` event of the input to close the
      // panel, but rather on a custom `touchstart`/`mousedown` event outside
      // of the autocomplete elements.
      // This ensures we don't mistakenly interpret interactions within the
      // autocomplete (but outside of the input) as a signal to close the panel.
      // For example, clicking reset button causes an input blur, but if
      // `openOnFocus=true`, it shouldn't close the panel.
      // On touch devices, scrolling results (`touchmove`) causes an input blur
      // but shouldn't close the panel.
      onTouchStart: onMouseDownOrTouchStart,
      onMouseDown: onMouseDownOrTouchStart,
      // When scrolling on touch devices (mobiles, tablets, etc.), we want to
      // mimic the native platform behavior where the input is blurred to
      // hide the virtual keyboard. This gives more vertical space to
      // discover all the suggestions showing up in the panel.
      onTouchMove: function onTouchMove(event) {
        if (store.getState().isOpen === false || inputElement !== props.environment.document.activeElement || event.target === inputElement) {
          return;
        }
        inputElement.blur();
      }
    }, rest);
  };
  var getRootProps = function getRootProps2(rest) {
    return _objectSpread11({
      role: "combobox",
      "aria-expanded": store.getState().isOpen,
      "aria-haspopup": "listbox",
      "aria-controls": store.getState().isOpen ? store.getState().collections.map(function(_ref2) {
        var source = _ref2.source;
        return getAutocompleteElementId(props.id, "list", source);
      }).join(" ") : void 0,
      "aria-labelledby": getAutocompleteElementId(props.id, "label")
    }, rest);
  };
  var getFormProps = function getFormProps2(providedProps) {
    var inputElement = providedProps.inputElement, rest = _objectWithoutProperties4(providedProps, _excluded32);
    var handleSubmit = function handleSubmit2(event) {
      var _providedProps$inputE;
      props.onSubmit(_objectSpread11({
        event,
        refresh,
        state: store.getState()
      }, setters));
      store.dispatch("submit", null);
      (_providedProps$inputE = providedProps.inputElement) === null || _providedProps$inputE === void 0 ? void 0 : _providedProps$inputE.blur();
    };
    return _objectSpread11({
      action: "",
      noValidate: true,
      role: "search",
      onSubmit: function onSubmit(event) {
        event.preventDefault();
        var waitForSubmit = getPluginSubmitPromise(props.plugins, store.pendingRequests);
        if (waitForSubmit !== void 0) {
          waitForSubmit.then(function() {
            return handleSubmit(event);
          });
        } else {
          handleSubmit(event);
        }
      },
      onReset: function onReset(event) {
        var _providedProps$inputE2;
        event.preventDefault();
        props.onReset(_objectSpread11({
          event,
          refresh,
          state: store.getState()
        }, setters));
        store.dispatch("reset", null);
        (_providedProps$inputE2 = providedProps.inputElement) === null || _providedProps$inputE2 === void 0 ? void 0 : _providedProps$inputE2.focus();
      }
    }, rest);
  };
  var getInputProps = function getInputProps2(providedProps) {
    var _props$environment$na;
    function onFocus(event) {
      if (props.openOnFocus || Boolean(store.getState().query)) {
        onInput(_objectSpread11({
          event,
          props,
          query: store.getState().completion || store.getState().query,
          refresh,
          store
        }, setters));
      }
      store.dispatch("focus", null);
    }
    var _ref3 = providedProps || {}, inputElement = _ref3.inputElement, _ref3$maxLength = _ref3.maxLength, maxLength = _ref3$maxLength === void 0 ? 512 : _ref3$maxLength, rest = _objectWithoutProperties4(_ref3, _excluded42);
    var activeItem = getActiveItem(store.getState());
    var userAgent = ((_props$environment$na = props.environment.navigator) === null || _props$environment$na === void 0 ? void 0 : _props$environment$na.userAgent) || "";
    var shouldFallbackKeyHint = isSamsung(userAgent);
    var enterKeyHint = props.enterKeyHint || (activeItem !== null && activeItem !== void 0 && activeItem.itemUrl && !shouldFallbackKeyHint ? "go" : "search");
    return _objectSpread11({
      "aria-autocomplete": "both",
      "aria-activedescendant": store.getState().isOpen && store.getState().activeItemId !== null ? getAutocompleteElementId(props.id, "item-".concat(store.getState().activeItemId), activeItem === null || activeItem === void 0 ? void 0 : activeItem.source) : void 0,
      "aria-controls": store.getState().isOpen ? store.getState().collections.filter(function(collection) {
        return collection.items.length > 0;
      }).map(function(_ref4) {
        var source = _ref4.source;
        return getAutocompleteElementId(props.id, "list", source);
      }).join(" ") : void 0,
      "aria-labelledby": getAutocompleteElementId(props.id, "label"),
      value: store.getState().completion || store.getState().query,
      id: getAutocompleteElementId(props.id, "input"),
      autoComplete: "off",
      autoCorrect: "off",
      autoCapitalize: "off",
      enterKeyHint,
      spellCheck: "false",
      autoFocus: props.autoFocus,
      placeholder: props.placeholder,
      maxLength,
      type: "search",
      onChange: function onChange(event) {
        var value = event.currentTarget.value;
        if (props.ignoreCompositionEvents && getNativeEvent(event).isComposing) {
          setters.setQuery(value);
          return;
        }
        onInput(_objectSpread11({
          event,
          props,
          query: value.slice(0, maxLength),
          refresh,
          store
        }, setters));
      },
      onCompositionEnd: function onCompositionEnd(event) {
        onInput(_objectSpread11({
          event,
          props,
          query: event.currentTarget.value.slice(0, maxLength),
          refresh,
          store
        }, setters));
      },
      onKeyDown: function onKeyDown2(event) {
        if (getNativeEvent(event).isComposing) {
          return;
        }
        onKeyDown(_objectSpread11({
          event,
          props,
          refresh,
          store
        }, setters));
      },
      onFocus,
      // We don't rely on the `blur` event.
      // See explanation in `onTouchStart`/`onMouseDown`.
      // @MAJOR See if we need to keep this handler.
      onBlur: noop3,
      onClick: function onClick(event) {
        if (providedProps.inputElement === props.environment.document.activeElement && !store.getState().isOpen) {
          onFocus(event);
        }
      }
    }, rest);
  };
  var getLabelProps = function getLabelProps2(rest) {
    return _objectSpread11({
      htmlFor: getAutocompleteElementId(props.id, "input"),
      id: getAutocompleteElementId(props.id, "label")
    }, rest);
  };
  var getListProps = function getListProps2(providedProps) {
    var _ref5 = providedProps || {}, source = _ref5.source, rest = _objectWithoutProperties4(_ref5, _excluded52);
    return _objectSpread11({
      role: "listbox",
      "aria-labelledby": getAutocompleteElementId(props.id, "label"),
      id: getAutocompleteElementId(props.id, "list", source)
    }, rest);
  };
  var getPanelProps = function getPanelProps2(rest) {
    return _objectSpread11({
      onMouseDown: function onMouseDown(event) {
        event.preventDefault();
      },
      onMouseLeave: function onMouseLeave() {
        store.dispatch("mouseleave", null);
      }
    }, rest);
  };
  var getItemProps = function getItemProps2(providedProps) {
    var item = providedProps.item, source = providedProps.source, rest = _objectWithoutProperties4(providedProps, _excluded6);
    return _objectSpread11({
      id: getAutocompleteElementId(props.id, "item-".concat(item.__autocomplete_id), source),
      role: "option",
      "aria-selected": store.getState().activeItemId === item.__autocomplete_id,
      onMouseMove: function onMouseMove(event) {
        if (item.__autocomplete_id === store.getState().activeItemId) {
          return;
        }
        store.dispatch("mousemove", item.__autocomplete_id);
        var activeItem = getActiveItem(store.getState());
        if (store.getState().activeItemId !== null && activeItem) {
          var _item = activeItem.item, itemInputValue = activeItem.itemInputValue, itemUrl = activeItem.itemUrl, _source = activeItem.source;
          _source.onActive(_objectSpread11({
            event,
            item: _item,
            itemInputValue,
            itemUrl,
            refresh,
            source: _source,
            state: store.getState()
          }, setters));
        }
      },
      onMouseDown: function onMouseDown(event) {
        event.preventDefault();
      },
      onClick: function onClick(event) {
        var itemInputValue = source.getItemInputValue({
          item,
          state: store.getState()
        });
        var itemUrl = source.getItemUrl({
          item,
          state: store.getState()
        });
        var runPreCommand = itemUrl ? Promise.resolve() : onInput(_objectSpread11({
          event,
          nextState: {
            isOpen: false
          },
          props,
          query: itemInputValue,
          refresh,
          store
        }, setters));
        runPreCommand.then(function() {
          source.onSelect(_objectSpread11({
            event,
            item,
            itemInputValue,
            itemUrl,
            refresh,
            source,
            state: store.getState()
          }, setters));
        });
      }
    }, rest);
  };
  return {
    getEnvironmentProps,
    getRootProps,
    getFormProps,
    getLabelProps,
    getInputProps,
    getPanelProps,
    getListProps,
    getItemProps
  };
}

// node_modules/@algolia/autocomplete-core/dist/esm/metadata.js
function _typeof13(obj) {
  "@babel/helpers - typeof";
  return _typeof13 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof13(obj);
}
function ownKeys12(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread12(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys12(Object(source), true).forEach(function(key) {
      _defineProperty12(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys12(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty12(obj, key, value) {
  key = _toPropertyKey12(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey12(arg) {
  var key = _toPrimitive12(arg, "string");
  return _typeof13(key) === "symbol" ? key : String(key);
}
function _toPrimitive12(input, hint) {
  if (_typeof13(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof13(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function getMetadata(_ref) {
  var _2, _options$__autocomple, _options$__autocomple2, _options$__autocomple3;
  var plugins = _ref.plugins, options = _ref.options;
  var optionsKey = (_2 = (((_options$__autocomple = options.__autocomplete_metadata) === null || _options$__autocomple === void 0 ? void 0 : _options$__autocomple.userAgents) || [])[0]) === null || _2 === void 0 ? void 0 : _2.segment;
  var extraOptions = optionsKey ? _defineProperty12({}, optionsKey, Object.keys(((_options$__autocomple2 = options.__autocomplete_metadata) === null || _options$__autocomple2 === void 0 ? void 0 : _options$__autocomple2.options) || {})) : {};
  return {
    plugins: plugins.map(function(plugin) {
      return {
        name: plugin.name,
        options: Object.keys(plugin.__autocomplete_pluginOptions || [])
      };
    }),
    options: _objectSpread12({
      "autocomplete-core": Object.keys(options)
    }, extraOptions),
    ua: userAgents.concat(((_options$__autocomple3 = options.__autocomplete_metadata) === null || _options$__autocomple3 === void 0 ? void 0 : _options$__autocomple3.userAgents) || [])
  };
}
function injectMetadata(_ref3) {
  var _environment$navigato, _environment$navigato2;
  var metadata = _ref3.metadata, environment = _ref3.environment;
  var isMetadataEnabled = (_environment$navigato = environment.navigator) === null || _environment$navigato === void 0 ? void 0 : (_environment$navigato2 = _environment$navigato.userAgent) === null || _environment$navigato2 === void 0 ? void 0 : _environment$navigato2.includes("Algolia Crawler");
  if (isMetadataEnabled) {
    var metadataContainer = environment.document.createElement("meta");
    var headRef = environment.document.querySelector("head");
    metadataContainer.name = "algolia:metadata";
    setTimeout(function() {
      metadataContainer.content = JSON.stringify(metadata);
      headRef.appendChild(metadataContainer);
    }, 0);
  }
}

// node_modules/@algolia/autocomplete-core/dist/esm/getCompletion.js
function getCompletion(_ref) {
  var _getActiveItem;
  var state = _ref.state;
  if (state.isOpen === false || state.activeItemId === null) {
    return null;
  }
  return ((_getActiveItem = getActiveItem(state)) === null || _getActiveItem === void 0 ? void 0 : _getActiveItem.itemInputValue) || null;
}

// node_modules/@algolia/autocomplete-core/dist/esm/stateReducer.js
function _typeof14(obj) {
  "@babel/helpers - typeof";
  return _typeof14 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof14(obj);
}
function ownKeys13(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread13(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys13(Object(source), true).forEach(function(key) {
      _defineProperty13(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys13(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty13(obj, key, value) {
  key = _toPropertyKey13(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey13(arg) {
  var key = _toPrimitive13(arg, "string");
  return _typeof14(key) === "symbol" ? key : String(key);
}
function _toPrimitive13(input, hint) {
  if (_typeof14(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof14(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var stateReducer = function stateReducer2(state, action) {
  switch (action.type) {
    case "setActiveItemId": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: action.payload
      });
    }
    case "setQuery": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        query: action.payload,
        completion: null
      });
    }
    case "setCollections": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        collections: action.payload
      });
    }
    case "setIsOpen": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        isOpen: action.payload
      });
    }
    case "setStatus": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        status: action.payload
      });
    }
    case "setContext": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        context: _objectSpread13(_objectSpread13({}, state.context), action.payload)
      });
    }
    case "ArrowDown": {
      var nextState = _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: action.payload.hasOwnProperty("nextActiveItemId") ? action.payload.nextActiveItemId : getNextActiveItemId(1, state.activeItemId, getItemsCount(state), action.props.defaultActiveItemId)
      });
      return _objectSpread13(_objectSpread13({}, nextState), {}, {
        completion: getCompletion({
          state: nextState
        })
      });
    }
    case "ArrowUp": {
      var _nextState = _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: getNextActiveItemId(-1, state.activeItemId, getItemsCount(state), action.props.defaultActiveItemId)
      });
      return _objectSpread13(_objectSpread13({}, _nextState), {}, {
        completion: getCompletion({
          state: _nextState
        })
      });
    }
    case "Escape": {
      if (state.isOpen) {
        return _objectSpread13(_objectSpread13({}, state), {}, {
          activeItemId: null,
          isOpen: false,
          completion: null
        });
      }
      return _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: null,
        query: "",
        status: "idle",
        collections: []
      });
    }
    case "submit": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: null,
        isOpen: false,
        status: "idle"
      });
    }
    case "reset": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: (
          // Since we open the panel on reset when openOnFocus=true
          // we need to restore the highlighted index to the defaultActiveItemId. (DocSearch use-case)
          // Since we close the panel when openOnFocus=false
          // we lose track of the highlighted index. (Query-suggestions use-case)
          action.props.openOnFocus === true ? action.props.defaultActiveItemId : null
        ),
        status: "idle",
        completion: null,
        query: ""
      });
    }
    case "focus": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: action.props.defaultActiveItemId,
        isOpen: (action.props.openOnFocus || Boolean(state.query)) && action.props.shouldPanelOpen({
          state
        })
      });
    }
    case "blur": {
      if (action.props.debug) {
        return state;
      }
      return _objectSpread13(_objectSpread13({}, state), {}, {
        isOpen: false,
        activeItemId: null
      });
    }
    case "mousemove": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: action.payload
      });
    }
    case "mouseleave": {
      return _objectSpread13(_objectSpread13({}, state), {}, {
        activeItemId: action.props.defaultActiveItemId
      });
    }
    default:
      invariant(false, "The reducer action ".concat(JSON.stringify(action.type), " is not supported."));
      return state;
  }
};

// node_modules/@algolia/autocomplete-core/dist/esm/createAutocomplete.js
function _typeof15(obj) {
  "@babel/helpers - typeof";
  return _typeof15 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof15(obj);
}
function ownKeys14(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread14(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys14(Object(source), true).forEach(function(key) {
      _defineProperty14(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys14(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty14(obj, key, value) {
  key = _toPropertyKey14(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey14(arg) {
  var key = _toPrimitive14(arg, "string");
  return _typeof15(key) === "symbol" ? key : String(key);
}
function _toPrimitive14(input, hint) {
  if (_typeof15(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof15(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function createAutocomplete(options) {
  checkOptions(options);
  var subscribers = [];
  var props = getDefaultProps(options, subscribers);
  var store = createStore(stateReducer, props, onStoreStateChange);
  var setters = getAutocompleteSetters({
    store
  });
  var propGetters = getPropGetters(_objectSpread14({
    props,
    refresh,
    store,
    navigator: props.navigator
  }, setters));
  function onStoreStateChange(_ref) {
    var _state$context, _state$context$algoli;
    var prevState = _ref.prevState, state = _ref.state;
    props.onStateChange(_objectSpread14({
      prevState,
      state,
      refresh,
      navigator: props.navigator
    }, setters));
    if (!isAlgoliaInsightsPluginEnabled() && (_state$context = state.context) !== null && _state$context !== void 0 && (_state$context$algoli = _state$context.algoliaInsightsPlugin) !== null && _state$context$algoli !== void 0 && _state$context$algoli.__automaticInsights && props.insights !== false) {
      var plugin = createAlgoliaInsightsPlugin({
        __autocomplete_clickAnalytics: false
      });
      props.plugins.push(plugin);
      subscribePlugins([plugin]);
    }
  }
  function refresh() {
    return onInput(_objectSpread14({
      event: new Event("input"),
      nextState: {
        isOpen: store.getState().isOpen
      },
      props,
      navigator: props.navigator,
      query: store.getState().query,
      refresh,
      store
    }, setters));
  }
  function subscribePlugins(plugins) {
    plugins.forEach(function(plugin) {
      var _plugin$subscribe;
      return (_plugin$subscribe = plugin.subscribe) === null || _plugin$subscribe === void 0 ? void 0 : _plugin$subscribe.call(plugin, _objectSpread14(_objectSpread14({}, setters), {}, {
        navigator: props.navigator,
        refresh,
        onSelect: function onSelect(fn) {
          subscribers.push({
            onSelect: fn
          });
        },
        onActive: function onActive(fn) {
          subscribers.push({
            onActive: fn
          });
        },
        onResolve: function onResolve(fn) {
          subscribers.push({
            onResolve: fn
          });
        }
      }));
    });
  }
  function isAlgoliaInsightsPluginEnabled() {
    return props.plugins.some(function(plugin) {
      return plugin.name === "aa.algoliaInsightsPlugin";
    });
  }
  if (props.insights && !isAlgoliaInsightsPluginEnabled()) {
    var insightsParams = typeof props.insights === "boolean" ? {} : props.insights;
    props.plugins.push(createAlgoliaInsightsPlugin(insightsParams));
  }
  subscribePlugins(props.plugins);
  injectMetadata({
    metadata: getMetadata({
      plugins: props.plugins,
      options
    }),
    environment: props.environment
  });
  return _objectSpread14(_objectSpread14({
    refresh,
    navigator: props.navigator
  }, propGetters), setters);
}

// node_modules/htm/dist/htm.module.js
var n = function(t3, s2, r2, e2) {
  var u2;
  s2[0] = 0;
  for (var h2 = 1; h2 < s2.length; h2++) {
    var p2 = s2[h2++], a2 = s2[h2] ? (s2[0] |= p2 ? 1 : 2, r2[s2[h2++]]) : s2[++h2];
    3 === p2 ? e2[0] = a2 : 4 === p2 ? e2[1] = Object.assign(e2[1] || {}, a2) : 5 === p2 ? (e2[1] = e2[1] || {})[s2[++h2]] = a2 : 6 === p2 ? e2[1][s2[++h2]] += a2 + "" : p2 ? (u2 = t3.apply(a2, n(t3, a2, r2, ["", null])), e2.push(u2), a2[0] ? s2[0] |= 2 : (s2[h2 - 2] = 0, s2[h2] = u2)) : e2.push(a2);
  }
  return e2;
};
var t = /* @__PURE__ */ new Map();
function htm_module_default(s2) {
  var r2 = t.get(this);
  return r2 || (r2 = /* @__PURE__ */ new Map(), t.set(this, r2)), (r2 = n(this, r2.get(s2) || (r2.set(s2, r2 = function(n3) {
    for (var t3, s3, r3 = 1, e2 = "", u2 = "", h2 = [0], p2 = function(n4) {
      1 === r3 && (n4 || (e2 = e2.replace(/^\s*\n\s*|\s*\n\s*$/g, ""))) ? h2.push(0, n4, e2) : 3 === r3 && (n4 || e2) ? (h2.push(3, n4, e2), r3 = 2) : 2 === r3 && "..." === e2 && n4 ? h2.push(4, n4, 0) : 2 === r3 && e2 && !n4 ? h2.push(5, 0, true, e2) : r3 >= 5 && ((e2 || !n4 && 5 === r3) && (h2.push(r3, 0, e2, s3), r3 = 6), n4 && (h2.push(r3, n4, 0, s3), r3 = 6)), e2 = "";
    }, a2 = 0; a2 < n3.length; a2++) {
      a2 && (1 === r3 && p2(), p2(a2));
      for (var l2 = 0; l2 < n3[a2].length; l2++) t3 = n3[a2][l2], 1 === r3 ? "<" === t3 ? (p2(), h2 = [h2], r3 = 3) : e2 += t3 : 4 === r3 ? "--" === e2 && ">" === t3 ? (r3 = 1, e2 = "") : e2 = t3 + e2[0] : u2 ? t3 === u2 ? u2 = "" : e2 += t3 : '"' === t3 || "'" === t3 ? u2 = t3 : ">" === t3 ? (p2(), r3 = 1) : r3 && ("=" === t3 ? (r3 = 5, s3 = e2, e2 = "") : "/" === t3 && (r3 < 5 || ">" === n3[a2][l2 + 1]) ? (p2(), 3 === r3 && (h2 = h2[0]), r3 = h2, (h2 = h2[0]).push(2, 0, r3), r3 = 0) : " " === t3 || "	" === t3 || "\n" === t3 || "\r" === t3 ? (p2(), r3 = 2) : e2 += t3), 3 === r3 && "!--" === e2 && (r3 = 4, h2 = h2[0]);
    }
    return p2(), h2;
  }(s2)), r2), arguments, [])).length > 1 ? r2 : r2[0];
}

// node_modules/@algolia/autocomplete-js/dist/esm/elements/ClearIcon.js
var ClearIcon = function ClearIcon2(_ref) {
  var environment = _ref.environment;
  var element = environment.document.createElementNS("http://www.w3.org/2000/svg", "svg");
  element.setAttribute("class", "aa-ClearIcon");
  element.setAttribute("viewBox", "0 0 24 24");
  element.setAttribute("width", "18");
  element.setAttribute("height", "18");
  element.setAttribute("fill", "currentColor");
  var path = environment.document.createElementNS("http://www.w3.org/2000/svg", "path");
  path.setAttribute("d", "M5.293 6.707l5.293 5.293-5.293 5.293c-0.391 0.391-0.391 1.024 0 1.414s1.024 0.391 1.414 0l5.293-5.293 5.293 5.293c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414l-5.293-5.293 5.293-5.293c0.391-0.391 0.391-1.024 0-1.414s-1.024-0.391-1.414 0l-5.293 5.293-5.293-5.293c-0.391-0.391-1.024-0.391-1.414 0s-0.391 1.024 0 1.414z");
  element.appendChild(path);
  return element;
};

// node_modules/@algolia/autocomplete-js/dist/esm/utils/getHTMLElement.js
function getHTMLElement(environment, value) {
  if (typeof value === "string") {
    var element = environment.document.querySelector(value);
    invariant(element !== null, "The element ".concat(JSON.stringify(value), " is not in the document."));
    return element;
  }
  return value;
}

// node_modules/@algolia/autocomplete-js/dist/esm/utils/mergeClassNames.js
function mergeClassNames() {
  for (var _len = arguments.length, values = new Array(_len), _key = 0; _key < _len; _key++) {
    values[_key] = arguments[_key];
  }
  return values.reduce(function(acc, current) {
    Object.keys(current).forEach(function(key) {
      var accValue = acc[key];
      var currentValue = current[key];
      if (accValue !== currentValue) {
        acc[key] = [accValue, currentValue].filter(Boolean).join(" ");
      }
    });
    return acc;
  }, {});
}

// node_modules/@algolia/autocomplete-js/dist/esm/utils/mergeDeep.js
function _toConsumableArray5(arr) {
  return _arrayWithoutHoles5(arr) || _iterableToArray5(arr) || _unsupportedIterableToArray8(arr) || _nonIterableSpread5();
}
function _nonIterableSpread5() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray8(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray8(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray8(o2, minLen);
}
function _iterableToArray5(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles5(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray8(arr);
}
function _arrayLikeToArray8(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function _typeof16(obj) {
  "@babel/helpers - typeof";
  return _typeof16 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof16(obj);
}
var isPlainObject = function isPlainObject2(value) {
  return value && _typeof16(value) === "object" && Object.prototype.toString.call(value) === "[object Object]";
};
function mergeDeep() {
  for (var _len = arguments.length, values = new Array(_len), _key = 0; _key < _len; _key++) {
    values[_key] = arguments[_key];
  }
  return values.reduce(function(acc, current) {
    Object.keys(current).forEach(function(key) {
      var accValue = acc[key];
      var currentValue = current[key];
      if (Array.isArray(accValue) && Array.isArray(currentValue)) {
        acc[key] = accValue.concat.apply(accValue, _toConsumableArray5(currentValue));
      } else if (isPlainObject(accValue) && isPlainObject(currentValue)) {
        acc[key] = mergeDeep(accValue, currentValue);
      } else {
        acc[key] = currentValue;
      }
    });
    return acc;
  }, {});
}

// node_modules/@algolia/autocomplete-js/dist/esm/utils/pickBy.js
function _typeof17(obj) {
  "@babel/helpers - typeof";
  return _typeof17 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof17(obj);
}
function ownKeys15(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread15(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys15(Object(source), true).forEach(function(key) {
      _defineProperty15(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys15(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty15(obj, key, value) {
  key = _toPropertyKey15(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey15(arg) {
  var key = _toPrimitive15(arg, "string");
  return _typeof17(key) === "symbol" ? key : String(key);
}
function _toPrimitive15(input, hint) {
  if (_typeof17(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof17(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _slicedToArray3(arr, i2) {
  return _arrayWithHoles3(arr) || _iterableToArrayLimit3(arr, i2) || _unsupportedIterableToArray9(arr, i2) || _nonIterableRest3();
}
function _nonIterableRest3() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray9(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray9(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray9(o2, minLen);
}
function _arrayLikeToArray9(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function _iterableToArrayLimit3(arr, i2) {
  var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
  if (null != _i) {
    var _s, _e, _x, _r, _arr = [], _n = true, _d = false;
    try {
      if (_x = (_i = _i.call(arr)).next, 0 === i2) {
        if (Object(_i) !== _i) return;
        _n = false;
      } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i2); _n = true) ;
    } catch (err) {
      _d = true, _e = err;
    } finally {
      try {
        if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return;
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
}
function _arrayWithHoles3(arr) {
  if (Array.isArray(arr)) return arr;
}
function pickBy(obj, predicate) {
  return Object.entries(obj).reduce(function(acc, _ref) {
    var _ref2 = _slicedToArray3(_ref, 2), key = _ref2[0], value = _ref2[1];
    if (predicate({
      key,
      value
    })) {
      return _objectSpread15(_objectSpread15({}, acc), {}, _defineProperty15({}, key, value));
    }
    return acc;
  }, {});
}

// node_modules/@algolia/autocomplete-js/dist/esm/utils/setProperties.js
var TOUCH_EVENTS_ALIASES = ["ontouchstart", "ontouchend", "ontouchmove", "ontouchcancel"];
function setStyle(style, key, value) {
  if (value === null) {
    style[key] = "";
  } else if (typeof value !== "number") {
    style[key] = value;
  } else {
    style[key] = value + "px";
  }
}
function eventProxy(event) {
  this._listeners[event.type](event);
}
function setProperty(dom, name, value) {
  var useCapture;
  var nameLower;
  var oldValue = dom[name];
  if (name === "style") {
    if (typeof value == "string") {
      dom.style = value;
    } else {
      if (value === null) {
        dom.style = "";
      } else {
        for (name in value) {
          if (!oldValue || value[name] !== oldValue[name]) {
            setStyle(dom.style, name, value[name]);
          }
        }
      }
    }
  } else if (name[0] === "o" && name[1] === "n") {
    useCapture = name !== (name = name.replace(/Capture$/, ""));
    nameLower = name.toLowerCase();
    if (nameLower in dom || TOUCH_EVENTS_ALIASES.includes(nameLower)) name = nameLower;
    name = name.slice(2);
    if (!dom._listeners) dom._listeners = {};
    dom._listeners[name] = value;
    if (value) {
      if (!oldValue) dom.addEventListener(name, eventProxy, useCapture);
    } else {
      dom.removeEventListener(name, eventProxy, useCapture);
    }
  } else if (name !== "list" && name !== "tagName" && // HTMLButtonElement.form and HTMLInputElement.form are read-only but can be set using
  // setAttribute
  name !== "form" && name !== "type" && name !== "size" && name !== "download" && name !== "href" && name in dom) {
    dom[name] = value == null ? "" : value;
  } else if (typeof value != "function" && name !== "dangerouslySetInnerHTML") {
    if (value == null || value === false && // ARIA-attributes have a different notion of boolean values.
    // The value `false` is different from the attribute not
    // existing on the DOM, so we can't remove it. For non-boolean
    // ARIA-attributes we could treat false as a removal, but the
    // amount of exceptions would cost us too many bytes. On top of
    // that other VDOM frameworks also always stringify `false`.
    !/^ar/.test(name)) {
      dom.removeAttribute(name);
    } else {
      dom.setAttribute(name, value);
    }
  }
}
function getNormalizedName(name) {
  switch (name) {
    case "onChange":
      return "onInput";
    // see: https://github.com/preactjs/preact/issues/1978
    case "onCompositionEnd":
      return "oncompositionend";
    default:
      return name;
  }
}
function setProperties(dom, props) {
  for (var name in props) {
    setProperty(dom, getNormalizedName(name), props[name]);
  }
}
function setPropertiesWithoutEvents(dom, props) {
  for (var name in props) {
    if (!(name[0] === "o" && name[1] === "n")) {
      setProperty(dom, getNormalizedName(name), props[name]);
    }
  }
}

// node_modules/@algolia/autocomplete-js/dist/esm/getCreateDomElement.js
var _excluded7 = ["children"];
function _toConsumableArray6(arr) {
  return _arrayWithoutHoles6(arr) || _iterableToArray6(arr) || _unsupportedIterableToArray10(arr) || _nonIterableSpread6();
}
function _nonIterableSpread6() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray10(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray10(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray10(o2, minLen);
}
function _iterableToArray6(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles6(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray10(arr);
}
function _arrayLikeToArray10(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function _objectWithoutProperties5(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose5(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose5(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function getCreateDomElement(environment) {
  return function createDomElement(tagName, _ref) {
    var _ref$children = _ref.children, children = _ref$children === void 0 ? [] : _ref$children, props = _objectWithoutProperties5(_ref, _excluded7);
    var element = environment.document.createElement(tagName);
    setProperties(element, props);
    element.append.apply(element, _toConsumableArray6(children));
    return element;
  };
}

// node_modules/@algolia/autocomplete-js/dist/esm/elements/Input.js
function _typeof18(obj) {
  "@babel/helpers - typeof";
  return _typeof18 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof18(obj);
}
var _excluded8 = ["autocompleteScopeApi", "environment", "classNames", "getInputProps", "getInputPropsCore", "isDetached", "state"];
function ownKeys16(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread16(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys16(Object(source), true).forEach(function(key) {
      _defineProperty16(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys16(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty16(obj, key, value) {
  key = _toPropertyKey16(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey16(arg) {
  var key = _toPrimitive16(arg, "string");
  return _typeof18(key) === "symbol" ? key : String(key);
}
function _toPrimitive16(input, hint) {
  if (_typeof18(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof18(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _objectWithoutProperties6(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose6(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose6(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
var Input = function Input2(_ref) {
  var autocompleteScopeApi = _ref.autocompleteScopeApi, environment = _ref.environment, classNames = _ref.classNames, getInputProps = _ref.getInputProps, getInputPropsCore = _ref.getInputPropsCore, isDetached = _ref.isDetached, state = _ref.state, props = _objectWithoutProperties6(_ref, _excluded8);
  var createDomElement = getCreateDomElement(environment);
  var element = createDomElement("input", props);
  var inputProps = getInputProps(_objectSpread16({
    state,
    props: getInputPropsCore({
      inputElement: element
    }),
    inputElement: element
  }, autocompleteScopeApi));
  setProperties(element, _objectSpread16(_objectSpread16({}, inputProps), {}, {
    onKeyDown: function onKeyDown2(event) {
      if (isDetached && event.key === "Tab") {
        return;
      }
      inputProps.onKeyDown(event);
    }
  }));
  return element;
};

// node_modules/@algolia/autocomplete-js/dist/esm/elements/LoadingIcon.js
var LoadingIcon = function LoadingIcon2(_ref) {
  var environment = _ref.environment;
  var element = environment.document.createElementNS("http://www.w3.org/2000/svg", "svg");
  element.setAttribute("class", "aa-LoadingIcon");
  element.setAttribute("viewBox", "0 0 100 100");
  element.setAttribute("width", "20");
  element.setAttribute("height", "20");
  element.innerHTML = '<circle\n  cx="50"\n  cy="50"\n  fill="none"\n  r="35"\n  stroke="currentColor"\n  stroke-dasharray="164.93361431346415 56.97787143782138"\n  stroke-width="6"\n>\n  <animateTransform\n    attributeName="transform"\n    type="rotate"\n    repeatCount="indefinite"\n    dur="1s"\n    values="0 50 50;90 50 50;180 50 50;360 50 50"\n    keyTimes="0;0.40;0.65;1"\n  />\n</circle>';
  return element;
};

// node_modules/@algolia/autocomplete-js/dist/esm/elements/SearchIcon.js
var SearchIcon = function SearchIcon2(_ref) {
  var environment = _ref.environment;
  var element = environment.document.createElementNS("http://www.w3.org/2000/svg", "svg");
  element.setAttribute("class", "aa-SubmitIcon");
  element.setAttribute("viewBox", "0 0 24 24");
  element.setAttribute("width", "20");
  element.setAttribute("height", "20");
  element.setAttribute("fill", "currentColor");
  var path = environment.document.createElementNS("http://www.w3.org/2000/svg", "path");
  path.setAttribute("d", "M16.041 15.856c-0.034 0.026-0.067 0.055-0.099 0.087s-0.060 0.064-0.087 0.099c-1.258 1.213-2.969 1.958-4.855 1.958-1.933 0-3.682-0.782-4.95-2.050s-2.050-3.017-2.050-4.95 0.782-3.682 2.050-4.95 3.017-2.050 4.95-2.050 3.682 0.782 4.95 2.050 2.050 3.017 2.050 4.95c0 1.886-0.745 3.597-1.959 4.856zM21.707 20.293l-3.675-3.675c1.231-1.54 1.968-3.493 1.968-5.618 0-2.485-1.008-4.736-2.636-6.364s-3.879-2.636-6.364-2.636-4.736 1.008-6.364 2.636-2.636 3.879-2.636 6.364 1.008 4.736 2.636 6.364 3.879 2.636 6.364 2.636c2.125 0 4.078-0.737 5.618-1.968l3.675 3.675c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414z");
  element.appendChild(path);
  return element;
};

// node_modules/@algolia/autocomplete-js/dist/esm/createAutocompleteDom.js
function _typeof19(obj) {
  "@babel/helpers - typeof";
  return _typeof19 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof19(obj);
}
function ownKeys17(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread17(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys17(Object(source), true).forEach(function(key) {
      _defineProperty17(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys17(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty17(obj, key, value) {
  key = _toPropertyKey17(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey17(arg) {
  var key = _toPrimitive17(arg, "string");
  return _typeof19(key) === "symbol" ? key : String(key);
}
function _toPrimitive17(input, hint) {
  if (_typeof19(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof19(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function createAutocompleteDom(_ref) {
  var autocomplete2 = _ref.autocomplete, autocompleteScopeApi = _ref.autocompleteScopeApi, classNames = _ref.classNames, environment = _ref.environment, isDetached = _ref.isDetached, _ref$placeholder = _ref.placeholder, placeholder = _ref$placeholder === void 0 ? "Search" : _ref$placeholder, propGetters = _ref.propGetters, setIsModalOpen = _ref.setIsModalOpen, state = _ref.state, translations = _ref.translations;
  var createDomElement = getCreateDomElement(environment);
  var rootProps = propGetters.getRootProps(_objectSpread17({
    state,
    props: autocomplete2.getRootProps({})
  }, autocompleteScopeApi));
  var root = createDomElement("div", _objectSpread17({
    class: classNames.root
  }, rootProps));
  var detachedContainer = createDomElement("div", {
    class: classNames.detachedContainer,
    onMouseDown: function onMouseDown(event) {
      event.stopPropagation();
    }
  });
  var detachedOverlay = createDomElement("div", {
    class: classNames.detachedOverlay,
    children: [detachedContainer],
    onMouseDown: function onMouseDown() {
      setIsModalOpen(false);
      autocomplete2.setIsOpen(false);
    }
  });
  var labelProps = propGetters.getLabelProps(_objectSpread17({
    state,
    props: autocomplete2.getLabelProps({})
  }, autocompleteScopeApi));
  var submitButton = createDomElement("button", {
    class: classNames.submitButton,
    type: "submit",
    title: translations.submitButtonTitle,
    children: [SearchIcon({
      environment
    })]
  });
  var label = createDomElement("label", _objectSpread17({
    class: classNames.label,
    children: [submitButton],
    ariaLabel: translations.submitButtonTitle
  }, labelProps));
  var clearButton = createDomElement("button", {
    class: classNames.clearButton,
    type: "reset",
    title: translations.clearButtonTitle,
    children: [ClearIcon({
      environment
    })]
  });
  var loadingIndicator = createDomElement("div", {
    class: classNames.loadingIndicator,
    children: [LoadingIcon({
      environment
    })]
  });
  var input = Input({
    class: classNames.input,
    environment,
    state,
    getInputProps: propGetters.getInputProps,
    getInputPropsCore: autocomplete2.getInputProps,
    autocompleteScopeApi,
    isDetached
  });
  var inputWrapperPrefix = createDomElement("div", {
    class: classNames.inputWrapperPrefix,
    children: [label, loadingIndicator]
  });
  var inputWrapperSuffix = createDomElement("div", {
    class: classNames.inputWrapperSuffix,
    children: [clearButton]
  });
  var inputWrapper = createDomElement("div", {
    class: classNames.inputWrapper,
    children: [input]
  });
  var formProps = propGetters.getFormProps(_objectSpread17({
    state,
    props: autocomplete2.getFormProps({
      inputElement: input
    })
  }, autocompleteScopeApi));
  var form = createDomElement("form", _objectSpread17({
    class: classNames.form,
    children: [inputWrapperPrefix, inputWrapper, inputWrapperSuffix]
  }, formProps));
  var panelProps = propGetters.getPanelProps(_objectSpread17({
    state,
    props: autocomplete2.getPanelProps({})
  }, autocompleteScopeApi));
  var panel = createDomElement("div", _objectSpread17({
    class: classNames.panel
  }, panelProps));
  var detachedSearchButtonQuery = createDomElement("div", {
    class: classNames.detachedSearchButtonQuery,
    textContent: state.query
  });
  var detachedSearchButtonPlaceholder = createDomElement("div", {
    class: classNames.detachedSearchButtonPlaceholder,
    hidden: Boolean(state.query),
    textContent: placeholder
  });
  if (false) {
    setProperties(panel, {
      "data-testid": "panel"
    });
  }
  if (isDetached) {
    var detachedSearchButtonIcon = createDomElement("div", {
      class: classNames.detachedSearchButtonIcon,
      ariaLabel: translations.detachedSearchButtonTitle,
      children: [SearchIcon({
        environment
      })]
    });
    var detachedSearchButton = createDomElement("button", {
      type: "button",
      class: classNames.detachedSearchButton,
      title: translations.detachedSearchButtonTitle,
      id: labelProps.id,
      onClick: function onClick() {
        setIsModalOpen(true);
      },
      children: [detachedSearchButtonIcon, detachedSearchButtonPlaceholder, detachedSearchButtonQuery]
    });
    var detachedCancelButton = createDomElement("button", {
      type: "button",
      class: classNames.detachedCancelButton,
      textContent: translations.detachedCancelButtonText,
      // Prevent `onTouchStart` from closing the panel
      // since it should be initiated by `onClick` only
      onTouchStart: function onTouchStart(event) {
        event.stopPropagation();
      },
      onClick: function onClick() {
        autocomplete2.setIsOpen(false);
        setIsModalOpen(false);
      }
    });
    var detachedFormContainer = createDomElement("div", {
      class: classNames.detachedFormContainer,
      children: [form, detachedCancelButton]
    });
    detachedContainer.appendChild(detachedFormContainer);
    root.appendChild(detachedSearchButton);
  } else {
    root.appendChild(form);
  }
  return {
    detachedContainer,
    detachedOverlay,
    detachedSearchButtonQuery,
    detachedSearchButtonPlaceholder,
    inputWrapper,
    input,
    root,
    form,
    label,
    submitButton,
    clearButton,
    loadingIndicator,
    panel
  };
}

// node_modules/@algolia/autocomplete-js/dist/esm/createEffectWrapper.js
function createEffectWrapper() {
  var effects = [];
  var cleanups = [];
  function runEffect(fn) {
    effects.push(fn);
    var effectCleanup = fn();
    cleanups.push(effectCleanup);
  }
  return {
    runEffect,
    cleanupEffects: function cleanupEffects() {
      var currentCleanups = cleanups;
      cleanups = [];
      currentCleanups.forEach(function(cleanup) {
        cleanup();
      });
    },
    runEffects: function runEffects() {
      var currentEffects = effects;
      effects = [];
      currentEffects.forEach(function(effect) {
        runEffect(effect);
      });
    }
  };
}

// node_modules/@algolia/autocomplete-js/dist/esm/createReactiveWrapper.js
function createReactiveWrapper() {
  var reactives = [];
  return {
    reactive: function reactive(value) {
      var current = value();
      var reactive2 = {
        _fn: value,
        _ref: {
          current
        },
        get value() {
          return this._ref.current;
        },
        set value(value2) {
          this._ref.current = value2;
        }
      };
      reactives.push(reactive2);
      return reactive2;
    },
    runReactives: function runReactives() {
      reactives.forEach(function(value) {
        value._ref.current = value._fn();
      });
    }
  };
}

// node_modules/preact/dist/preact.module.js
var n2;
var l;
var u;
var t2;
var i;
var r;
var o;
var e;
var f;
var c;
var s;
var a;
var h;
var p = {};
var y = [];
var v = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
var w = Array.isArray;
function d(n3, l2) {
  for (var u2 in l2) n3[u2] = l2[u2];
  return n3;
}
function g(n3) {
  n3 && n3.parentNode && n3.parentNode.removeChild(n3);
}
function _(l2, u2, t3) {
  var i2, r2, o2, e2 = {};
  for (o2 in u2) "key" == o2 ? i2 = u2[o2] : "ref" == o2 ? r2 = u2[o2] : e2[o2] = u2[o2];
  if (arguments.length > 2 && (e2.children = arguments.length > 3 ? n2.call(arguments, 2) : t3), "function" == typeof l2 && null != l2.defaultProps) for (o2 in l2.defaultProps) null == e2[o2] && (e2[o2] = l2.defaultProps[o2]);
  return m(l2, e2, i2, r2, null);
}
function m(n3, t3, i2, r2, o2) {
  var e2 = { type: n3, props: t3, key: i2, ref: r2, __k: null, __: null, __b: 0, __e: null, __c: null, constructor: void 0, __v: null == o2 ? ++u : o2, __i: -1, __u: 0 };
  return null == o2 && null != l.vnode && l.vnode(e2), e2;
}
function k(n3) {
  return n3.children;
}
function x(n3, l2) {
  this.props = n3, this.context = l2;
}
function S(n3, l2) {
  if (null == l2) return n3.__ ? S(n3.__, n3.__i + 1) : null;
  for (var u2; l2 < n3.__k.length; l2++) if (null != (u2 = n3.__k[l2]) && null != u2.__e) return u2.__e;
  return "function" == typeof n3.type ? S(n3) : null;
}
function C(n3) {
  var l2, u2;
  if (null != (n3 = n3.__) && null != n3.__c) {
    for (n3.__e = n3.__c.base = null, l2 = 0; l2 < n3.__k.length; l2++) if (null != (u2 = n3.__k[l2]) && null != u2.__e) {
      n3.__e = n3.__c.base = u2.__e;
      break;
    }
    return C(n3);
  }
}
function M(n3) {
  (!n3.__d && (n3.__d = true) && i.push(n3) && !$.__r++ || r != l.debounceRendering) && ((r = l.debounceRendering) || o)($);
}
function $() {
  for (var n3, u2, t3, r2, o2, f2, c2, s2 = 1; i.length; ) i.length > s2 && i.sort(e), n3 = i.shift(), s2 = i.length, n3.__d && (t3 = void 0, o2 = (r2 = (u2 = n3).__v).__e, f2 = [], c2 = [], u2.__P && ((t3 = d({}, r2)).__v = r2.__v + 1, l.vnode && l.vnode(t3), O(u2.__P, t3, r2, u2.__n, u2.__P.namespaceURI, 32 & r2.__u ? [o2] : null, f2, null == o2 ? S(r2) : o2, !!(32 & r2.__u), c2), t3.__v = r2.__v, t3.__.__k[t3.__i] = t3, z(f2, t3, c2), t3.__e != o2 && C(t3)));
  $.__r = 0;
}
function I(n3, l2, u2, t3, i2, r2, o2, e2, f2, c2, s2) {
  var a2, h2, v2, w2, d2, g2, _2 = t3 && t3.__k || y, m2 = l2.length;
  for (f2 = P(u2, l2, _2, f2, m2), a2 = 0; a2 < m2; a2++) null != (v2 = u2.__k[a2]) && (h2 = -1 == v2.__i ? p : _2[v2.__i] || p, v2.__i = a2, g2 = O(n3, v2, h2, i2, r2, o2, e2, f2, c2, s2), w2 = v2.__e, v2.ref && h2.ref != v2.ref && (h2.ref && q(h2.ref, null, v2), s2.push(v2.ref, v2.__c || w2, v2)), null == d2 && null != w2 && (d2 = w2), 4 & v2.__u || h2.__k === v2.__k ? f2 = A(v2, f2, n3) : "function" == typeof v2.type && void 0 !== g2 ? f2 = g2 : w2 && (f2 = w2.nextSibling), v2.__u &= -7);
  return u2.__e = d2, f2;
}
function P(n3, l2, u2, t3, i2) {
  var r2, o2, e2, f2, c2, s2 = u2.length, a2 = s2, h2 = 0;
  for (n3.__k = new Array(i2), r2 = 0; r2 < i2; r2++) null != (o2 = l2[r2]) && "boolean" != typeof o2 && "function" != typeof o2 ? (f2 = r2 + h2, (o2 = n3.__k[r2] = "string" == typeof o2 || "number" == typeof o2 || "bigint" == typeof o2 || o2.constructor == String ? m(null, o2, null, null, null) : w(o2) ? m(k, { children: o2 }, null, null, null) : null == o2.constructor && o2.__b > 0 ? m(o2.type, o2.props, o2.key, o2.ref ? o2.ref : null, o2.__v) : o2).__ = n3, o2.__b = n3.__b + 1, e2 = null, -1 != (c2 = o2.__i = L(o2, u2, f2, a2)) && (a2--, (e2 = u2[c2]) && (e2.__u |= 2)), null == e2 || null == e2.__v ? (-1 == c2 && (i2 > s2 ? h2-- : i2 < s2 && h2++), "function" != typeof o2.type && (o2.__u |= 4)) : c2 != f2 && (c2 == f2 - 1 ? h2-- : c2 == f2 + 1 ? h2++ : (c2 > f2 ? h2-- : h2++, o2.__u |= 4))) : n3.__k[r2] = null;
  if (a2) for (r2 = 0; r2 < s2; r2++) null != (e2 = u2[r2]) && 0 == (2 & e2.__u) && (e2.__e == t3 && (t3 = S(e2)), B(e2, e2));
  return t3;
}
function A(n3, l2, u2) {
  var t3, i2;
  if ("function" == typeof n3.type) {
    for (t3 = n3.__k, i2 = 0; t3 && i2 < t3.length; i2++) t3[i2] && (t3[i2].__ = n3, l2 = A(t3[i2], l2, u2));
    return l2;
  }
  n3.__e != l2 && (l2 && n3.type && !u2.contains(l2) && (l2 = S(n3)), u2.insertBefore(n3.__e, l2 || null), l2 = n3.__e);
  do {
    l2 = l2 && l2.nextSibling;
  } while (null != l2 && 8 == l2.nodeType);
  return l2;
}
function L(n3, l2, u2, t3) {
  var i2, r2, o2 = n3.key, e2 = n3.type, f2 = l2[u2];
  if (null === f2 && null == n3.key || f2 && o2 == f2.key && e2 == f2.type && 0 == (2 & f2.__u)) return u2;
  if (t3 > (null != f2 && 0 == (2 & f2.__u) ? 1 : 0)) for (i2 = u2 - 1, r2 = u2 + 1; i2 >= 0 || r2 < l2.length; ) {
    if (i2 >= 0) {
      if ((f2 = l2[i2]) && 0 == (2 & f2.__u) && o2 == f2.key && e2 == f2.type) return i2;
      i2--;
    }
    if (r2 < l2.length) {
      if ((f2 = l2[r2]) && 0 == (2 & f2.__u) && o2 == f2.key && e2 == f2.type) return r2;
      r2++;
    }
  }
  return -1;
}
function T(n3, l2, u2) {
  "-" == l2[0] ? n3.setProperty(l2, null == u2 ? "" : u2) : n3[l2] = null == u2 ? "" : "number" != typeof u2 || v.test(l2) ? u2 : u2 + "px";
}
function j(n3, l2, u2, t3, i2) {
  var r2;
  n: if ("style" == l2) if ("string" == typeof u2) n3.style.cssText = u2;
  else {
    if ("string" == typeof t3 && (n3.style.cssText = t3 = ""), t3) for (l2 in t3) u2 && l2 in u2 || T(n3.style, l2, "");
    if (u2) for (l2 in u2) t3 && u2[l2] == t3[l2] || T(n3.style, l2, u2[l2]);
  }
  else if ("o" == l2[0] && "n" == l2[1]) r2 = l2 != (l2 = l2.replace(f, "$1")), l2 = l2.toLowerCase() in n3 || "onFocusOut" == l2 || "onFocusIn" == l2 ? l2.toLowerCase().slice(2) : l2.slice(2), n3.l || (n3.l = {}), n3.l[l2 + r2] = u2, u2 ? t3 ? u2.u = t3.u : (u2.u = c, n3.addEventListener(l2, r2 ? a : s, r2)) : n3.removeEventListener(l2, r2 ? a : s, r2);
  else {
    if ("http://www.w3.org/2000/svg" == i2) l2 = l2.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
    else if ("width" != l2 && "height" != l2 && "href" != l2 && "list" != l2 && "form" != l2 && "tabIndex" != l2 && "download" != l2 && "rowSpan" != l2 && "colSpan" != l2 && "role" != l2 && "popover" != l2 && l2 in n3) try {
      n3[l2] = null == u2 ? "" : u2;
      break n;
    } catch (n4) {
    }
    "function" == typeof u2 || (null == u2 || false === u2 && "-" != l2[4] ? n3.removeAttribute(l2) : n3.setAttribute(l2, "popover" == l2 && 1 == u2 ? "" : u2));
  }
}
function F(n3) {
  return function(u2) {
    if (this.l) {
      var t3 = this.l[u2.type + n3];
      if (null == u2.t) u2.t = c++;
      else if (u2.t < t3.u) return;
      return t3(l.event ? l.event(u2) : u2);
    }
  };
}
function O(n3, u2, t3, i2, r2, o2, e2, f2, c2, s2) {
  var a2, h2, p2, y2, v2, _2, m2, b, S2, C2, M2, $2, P2, A2, H, L2, T2, j2 = u2.type;
  if (null != u2.constructor) return null;
  128 & t3.__u && (c2 = !!(32 & t3.__u), o2 = [f2 = u2.__e = t3.__e]), (a2 = l.__b) && a2(u2);
  n: if ("function" == typeof j2) try {
    if (b = u2.props, S2 = "prototype" in j2 && j2.prototype.render, C2 = (a2 = j2.contextType) && i2[a2.__c], M2 = a2 ? C2 ? C2.props.value : a2.__ : i2, t3.__c ? m2 = (h2 = u2.__c = t3.__c).__ = h2.__E : (S2 ? u2.__c = h2 = new j2(b, M2) : (u2.__c = h2 = new x(b, M2), h2.constructor = j2, h2.render = D), C2 && C2.sub(h2), h2.props = b, h2.state || (h2.state = {}), h2.context = M2, h2.__n = i2, p2 = h2.__d = true, h2.__h = [], h2._sb = []), S2 && null == h2.__s && (h2.__s = h2.state), S2 && null != j2.getDerivedStateFromProps && (h2.__s == h2.state && (h2.__s = d({}, h2.__s)), d(h2.__s, j2.getDerivedStateFromProps(b, h2.__s))), y2 = h2.props, v2 = h2.state, h2.__v = u2, p2) S2 && null == j2.getDerivedStateFromProps && null != h2.componentWillMount && h2.componentWillMount(), S2 && null != h2.componentDidMount && h2.__h.push(h2.componentDidMount);
    else {
      if (S2 && null == j2.getDerivedStateFromProps && b !== y2 && null != h2.componentWillReceiveProps && h2.componentWillReceiveProps(b, M2), !h2.__e && null != h2.shouldComponentUpdate && false === h2.shouldComponentUpdate(b, h2.__s, M2) || u2.__v == t3.__v) {
        for (u2.__v != t3.__v && (h2.props = b, h2.state = h2.__s, h2.__d = false), u2.__e = t3.__e, u2.__k = t3.__k, u2.__k.some(function(n4) {
          n4 && (n4.__ = u2);
        }), $2 = 0; $2 < h2._sb.length; $2++) h2.__h.push(h2._sb[$2]);
        h2._sb = [], h2.__h.length && e2.push(h2);
        break n;
      }
      null != h2.componentWillUpdate && h2.componentWillUpdate(b, h2.__s, M2), S2 && null != h2.componentDidUpdate && h2.__h.push(function() {
        h2.componentDidUpdate(y2, v2, _2);
      });
    }
    if (h2.context = M2, h2.props = b, h2.__P = n3, h2.__e = false, P2 = l.__r, A2 = 0, S2) {
      for (h2.state = h2.__s, h2.__d = false, P2 && P2(u2), a2 = h2.render(h2.props, h2.state, h2.context), H = 0; H < h2._sb.length; H++) h2.__h.push(h2._sb[H]);
      h2._sb = [];
    } else do {
      h2.__d = false, P2 && P2(u2), a2 = h2.render(h2.props, h2.state, h2.context), h2.state = h2.__s;
    } while (h2.__d && ++A2 < 25);
    h2.state = h2.__s, null != h2.getChildContext && (i2 = d(d({}, i2), h2.getChildContext())), S2 && !p2 && null != h2.getSnapshotBeforeUpdate && (_2 = h2.getSnapshotBeforeUpdate(y2, v2)), L2 = a2, null != a2 && a2.type === k && null == a2.key && (L2 = N(a2.props.children)), f2 = I(n3, w(L2) ? L2 : [L2], u2, t3, i2, r2, o2, e2, f2, c2, s2), h2.base = u2.__e, u2.__u &= -161, h2.__h.length && e2.push(h2), m2 && (h2.__E = h2.__ = null);
  } catch (n4) {
    if (u2.__v = null, c2 || null != o2) if (n4.then) {
      for (u2.__u |= c2 ? 160 : 128; f2 && 8 == f2.nodeType && f2.nextSibling; ) f2 = f2.nextSibling;
      o2[o2.indexOf(f2)] = null, u2.__e = f2;
    } else for (T2 = o2.length; T2--; ) g(o2[T2]);
    else u2.__e = t3.__e, u2.__k = t3.__k;
    l.__e(n4, u2, t3);
  }
  else null == o2 && u2.__v == t3.__v ? (u2.__k = t3.__k, u2.__e = t3.__e) : f2 = u2.__e = V(t3.__e, u2, t3, i2, r2, o2, e2, c2, s2);
  return (a2 = l.diffed) && a2(u2), 128 & u2.__u ? void 0 : f2;
}
function z(n3, u2, t3) {
  for (var i2 = 0; i2 < t3.length; i2++) q(t3[i2], t3[++i2], t3[++i2]);
  l.__c && l.__c(u2, n3), n3.some(function(u3) {
    try {
      n3 = u3.__h, u3.__h = [], n3.some(function(n4) {
        n4.call(u3);
      });
    } catch (n4) {
      l.__e(n4, u3.__v);
    }
  });
}
function N(n3) {
  return "object" != typeof n3 || null == n3 || n3.__b && n3.__b > 0 ? n3 : w(n3) ? n3.map(N) : d({}, n3);
}
function V(u2, t3, i2, r2, o2, e2, f2, c2, s2) {
  var a2, h2, y2, v2, d2, _2, m2, b = i2.props, k2 = t3.props, x2 = t3.type;
  if ("svg" == x2 ? o2 = "http://www.w3.org/2000/svg" : "math" == x2 ? o2 = "http://www.w3.org/1998/Math/MathML" : o2 || (o2 = "http://www.w3.org/1999/xhtml"), null != e2) {
    for (a2 = 0; a2 < e2.length; a2++) if ((d2 = e2[a2]) && "setAttribute" in d2 == !!x2 && (x2 ? d2.localName == x2 : 3 == d2.nodeType)) {
      u2 = d2, e2[a2] = null;
      break;
    }
  }
  if (null == u2) {
    if (null == x2) return document.createTextNode(k2);
    u2 = document.createElementNS(o2, x2, k2.is && k2), c2 && (l.__m && l.__m(t3, e2), c2 = false), e2 = null;
  }
  if (null == x2) b === k2 || c2 && u2.data == k2 || (u2.data = k2);
  else {
    if (e2 = e2 && n2.call(u2.childNodes), b = i2.props || p, !c2 && null != e2) for (b = {}, a2 = 0; a2 < u2.attributes.length; a2++) b[(d2 = u2.attributes[a2]).name] = d2.value;
    for (a2 in b) if (d2 = b[a2], "children" == a2) ;
    else if ("dangerouslySetInnerHTML" == a2) y2 = d2;
    else if (!(a2 in k2)) {
      if ("value" == a2 && "defaultValue" in k2 || "checked" == a2 && "defaultChecked" in k2) continue;
      j(u2, a2, null, d2, o2);
    }
    for (a2 in k2) d2 = k2[a2], "children" == a2 ? v2 = d2 : "dangerouslySetInnerHTML" == a2 ? h2 = d2 : "value" == a2 ? _2 = d2 : "checked" == a2 ? m2 = d2 : c2 && "function" != typeof d2 || b[a2] === d2 || j(u2, a2, d2, b[a2], o2);
    if (h2) c2 || y2 && (h2.__html == y2.__html || h2.__html == u2.innerHTML) || (u2.innerHTML = h2.__html), t3.__k = [];
    else if (y2 && (u2.innerHTML = ""), I("template" == t3.type ? u2.content : u2, w(v2) ? v2 : [v2], t3, i2, r2, "foreignObject" == x2 ? "http://www.w3.org/1999/xhtml" : o2, e2, f2, e2 ? e2[0] : i2.__k && S(i2, 0), c2, s2), null != e2) for (a2 = e2.length; a2--; ) g(e2[a2]);
    c2 || (a2 = "value", "progress" == x2 && null == _2 ? u2.removeAttribute("value") : null != _2 && (_2 !== u2[a2] || "progress" == x2 && !_2 || "option" == x2 && _2 != b[a2]) && j(u2, a2, _2, b[a2], o2), a2 = "checked", null != m2 && m2 != u2[a2] && j(u2, a2, m2, b[a2], o2));
  }
  return u2;
}
function q(n3, u2, t3) {
  try {
    if ("function" == typeof n3) {
      var i2 = "function" == typeof n3.__u;
      i2 && n3.__u(), i2 && null == u2 || (n3.__u = n3(u2));
    } else n3.current = u2;
  } catch (n4) {
    l.__e(n4, t3);
  }
}
function B(n3, u2, t3) {
  var i2, r2;
  if (l.unmount && l.unmount(n3), (i2 = n3.ref) && (i2.current && i2.current != n3.__e || q(i2, null, u2)), null != (i2 = n3.__c)) {
    if (i2.componentWillUnmount) try {
      i2.componentWillUnmount();
    } catch (n4) {
      l.__e(n4, u2);
    }
    i2.base = i2.__P = null;
  }
  if (i2 = n3.__k) for (r2 = 0; r2 < i2.length; r2++) i2[r2] && B(i2[r2], u2, t3 || "function" != typeof n3.type);
  t3 || g(n3.__e), n3.__c = n3.__ = n3.__e = void 0;
}
function D(n3, l2, u2) {
  return this.constructor(n3, u2);
}
function E(u2, t3, i2) {
  var r2, o2, e2, f2;
  t3 == document && (t3 = document.documentElement), l.__ && l.__(u2, t3), o2 = (r2 = "function" == typeof i2) ? null : i2 && i2.__k || t3.__k, e2 = [], f2 = [], O(t3, u2 = (!r2 && i2 || t3).__k = _(k, null, [u2]), o2 || p, p, t3.namespaceURI, !r2 && i2 ? [i2] : o2 ? null : t3.firstChild ? n2.call(t3.childNodes) : null, e2, !r2 && i2 ? i2 : o2 ? o2.__e : t3.firstChild, r2, f2), z(e2, u2, f2);
}
n2 = y.slice, l = { __e: function(n3, l2, u2, t3) {
  for (var i2, r2, o2; l2 = l2.__; ) if ((i2 = l2.__c) && !i2.__) try {
    if ((r2 = i2.constructor) && null != r2.getDerivedStateFromError && (i2.setState(r2.getDerivedStateFromError(n3)), o2 = i2.__d), null != i2.componentDidCatch && (i2.componentDidCatch(n3, t3 || {}), o2 = i2.__d), o2) return i2.__E = i2;
  } catch (l3) {
    n3 = l3;
  }
  throw n3;
} }, u = 0, t2 = function(n3) {
  return null != n3 && null == n3.constructor;
}, x.prototype.setState = function(n3, l2) {
  var u2;
  u2 = null != this.__s && this.__s != this.state ? this.__s : this.__s = d({}, this.state), "function" == typeof n3 && (n3 = n3(d({}, u2), this.props)), n3 && d(u2, n3), null != n3 && this.__v && (l2 && this._sb.push(l2), M(this));
}, x.prototype.forceUpdate = function(n3) {
  this.__v && (this.__e = true, n3 && this.__h.push(n3), M(this));
}, x.prototype.render = k, i = [], o = "function" == typeof Promise ? Promise.prototype.then.bind(Promise.resolve()) : setTimeout, e = function(n3, l2) {
  return n3.__v.__b - l2.__v.__b;
}, $.__r = 0, f = /(PointerCapture)$|Capture$/i, c = 0, s = F(false), a = F(true), h = 0;

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/constants/index.js
var HIGHLIGHT_PRE_TAG = "__aa-highlight__";
var HIGHLIGHT_POST_TAG = "__/aa-highlight__";

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/highlight/parseAttribute.js
function createAttributeSet() {
  var initialValue = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : [];
  var value = initialValue;
  return {
    get: function get() {
      return value;
    },
    add: function add(part) {
      var lastPart = value[value.length - 1];
      if ((lastPart === null || lastPart === void 0 ? void 0 : lastPart.isHighlighted) === part.isHighlighted) {
        value[value.length - 1] = {
          value: lastPart.value + part.value,
          isHighlighted: lastPart.isHighlighted
        };
      } else {
        value.push(part);
      }
    }
  };
}
function parseAttribute(_ref) {
  var highlightedValue = _ref.highlightedValue;
  var preTagParts = highlightedValue.split(HIGHLIGHT_PRE_TAG);
  var firstValue = preTagParts.shift();
  var parts = createAttributeSet(firstValue ? [{
    value: firstValue,
    isHighlighted: false
  }] : []);
  preTagParts.forEach(function(part) {
    var postTagParts = part.split(HIGHLIGHT_POST_TAG);
    parts.add({
      value: postTagParts[0],
      isHighlighted: true
    });
    if (postTagParts[1] !== "") {
      parts.add({
        value: postTagParts[1],
        isHighlighted: false
      });
    }
  });
  return parts.get();
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/highlight/parseAlgoliaHitHighlight.js
function _toConsumableArray7(arr) {
  return _arrayWithoutHoles7(arr) || _iterableToArray7(arr) || _unsupportedIterableToArray11(arr) || _nonIterableSpread7();
}
function _nonIterableSpread7() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray11(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray11(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray11(o2, minLen);
}
function _iterableToArray7(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles7(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray11(arr);
}
function _arrayLikeToArray11(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function parseAlgoliaHitHighlight(_ref) {
  var hit = _ref.hit, attribute = _ref.attribute;
  var path = Array.isArray(attribute) ? attribute : [attribute];
  var highlightedValue = getAttributeValueByPath(hit, ["_highlightResult"].concat(_toConsumableArray7(path), ["value"]));
  if (typeof highlightedValue !== "string") {
    true ? warn(false, 'The attribute "'.concat(path.join("."), '" described by the path ').concat(JSON.stringify(path), " does not exist on the hit. Did you set it in `attributesToHighlight`?") + "\nSee https://www.algolia.com/doc/api-reference/api-parameters/attributesToHighlight/") : void 0;
    highlightedValue = getAttributeValueByPath(hit, path) || "";
  }
  return parseAttribute({
    highlightedValue
  });
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/highlight/isPartHighlighted.js
var htmlEscapes = {
  "&amp;": "&",
  "&lt;": "<",
  "&gt;": ">",
  "&quot;": '"',
  "&#39;": "'"
};
var hasAlphanumeric = new RegExp(/\w/i);
var regexEscapedHtml = /&(amp|quot|lt|gt|#39);/g;
var regexHasEscapedHtml = RegExp(regexEscapedHtml.source);
function unescape(value) {
  return value && regexHasEscapedHtml.test(value) ? value.replace(regexEscapedHtml, function(character) {
    return htmlEscapes[character];
  }) : value;
}
function isPartHighlighted(parts, i2) {
  var _parts, _parts2;
  var current = parts[i2];
  var isNextHighlighted = ((_parts = parts[i2 + 1]) === null || _parts === void 0 ? void 0 : _parts.isHighlighted) || true;
  var isPreviousHighlighted = ((_parts2 = parts[i2 - 1]) === null || _parts2 === void 0 ? void 0 : _parts2.isHighlighted) || true;
  if (!hasAlphanumeric.test(unescape(current.value)) && isPreviousHighlighted === isNextHighlighted) {
    return isPreviousHighlighted;
  }
  return current.isHighlighted;
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/highlight/reverseHighlightedParts.js
function _typeof20(obj) {
  "@babel/helpers - typeof";
  return _typeof20 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof20(obj);
}
function ownKeys18(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread18(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys18(Object(source), true).forEach(function(key) {
      _defineProperty18(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys18(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty18(obj, key, value) {
  key = _toPropertyKey18(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey18(arg) {
  var key = _toPrimitive18(arg, "string");
  return _typeof20(key) === "symbol" ? key : String(key);
}
function _toPrimitive18(input, hint) {
  if (_typeof20(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof20(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function reverseHighlightedParts(parts) {
  if (!parts.some(function(part) {
    return part.isHighlighted;
  })) {
    return parts.map(function(part) {
      return _objectSpread18(_objectSpread18({}, part), {}, {
        isHighlighted: false
      });
    });
  }
  return parts.map(function(part, i2) {
    return _objectSpread18(_objectSpread18({}, part), {}, {
      isHighlighted: !isPartHighlighted(parts, i2)
    });
  });
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/highlight/parseAlgoliaHitReverseHighlight.js
function parseAlgoliaHitReverseHighlight(props) {
  return reverseHighlightedParts(parseAlgoliaHitHighlight(props));
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/highlight/parseAlgoliaHitSnippet.js
function _toConsumableArray8(arr) {
  return _arrayWithoutHoles8(arr) || _iterableToArray8(arr) || _unsupportedIterableToArray12(arr) || _nonIterableSpread8();
}
function _nonIterableSpread8() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray12(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray12(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray12(o2, minLen);
}
function _iterableToArray8(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles8(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray12(arr);
}
function _arrayLikeToArray12(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function parseAlgoliaHitSnippet(_ref) {
  var hit = _ref.hit, attribute = _ref.attribute;
  var path = Array.isArray(attribute) ? attribute : [attribute];
  var highlightedValue = getAttributeValueByPath(hit, ["_snippetResult"].concat(_toConsumableArray8(path), ["value"]));
  if (typeof highlightedValue !== "string") {
    true ? warn(false, 'The attribute "'.concat(path.join("."), '" described by the path ').concat(JSON.stringify(path), " does not exist on the hit. Did you set it in `attributesToSnippet`?") + "\nSee https://www.algolia.com/doc/api-reference/api-parameters/attributesToSnippet/") : void 0;
    highlightedValue = getAttributeValueByPath(hit, path) || "";
  }
  return parseAttribute({
    highlightedValue
  });
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/highlight/parseAlgoliaHitReverseSnippet.js
function parseAlgoliaHitReverseSnippet(props) {
  return reverseHighlightedParts(parseAlgoliaHitSnippet(props));
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/requester/createRequester.js
function _typeof21(obj) {
  "@babel/helpers - typeof";
  return _typeof21 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof21(obj);
}
function ownKeys19(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread19(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys19(Object(source), true).forEach(function(key) {
      _defineProperty19(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys19(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty19(obj, key, value) {
  key = _toPropertyKey19(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey19(arg) {
  var key = _toPrimitive19(arg, "string");
  return _typeof21(key) === "symbol" ? key : String(key);
}
function _toPrimitive19(input, hint) {
  if (_typeof21(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof21(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function createRequester(fetcher, requesterId) {
  function execute(fetcherParams) {
    return fetcher({
      searchClient: fetcherParams.searchClient,
      queries: fetcherParams.requests.map(function(x2) {
        return x2.query;
      })
    }).then(function(responses) {
      return responses.map(function(response, index) {
        var _fetcherParams$reques = fetcherParams.requests[index], sourceId = _fetcherParams$reques.sourceId, transformResponse2 = _fetcherParams$reques.transformResponse;
        return {
          items: response,
          sourceId,
          transformResponse: transformResponse2
        };
      });
    });
  }
  return function createSpecifiedRequester(requesterParams) {
    return function requester(requestParams) {
      return _objectSpread19(_objectSpread19({
        requesterId,
        execute
      }, requesterParams), requestParams);
    };
  };
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/utils/getAppIdAndApiKey.js
function getAppIdAndApiKey(searchClient) {
  var transporter = searchClient.transporter || {};
  var headers = transporter.headers || transporter.baseHeaders || {};
  var queryParameters = transporter.queryParameters || transporter.baseQueryParameters || {};
  var APP_ID = "x-algolia-application-id";
  var API_KEY = "x-algolia-api-key";
  var appId = headers[APP_ID] || queryParameters[APP_ID];
  var apiKey = headers[API_KEY] || queryParameters[API_KEY];
  return {
    appId,
    apiKey
  };
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/search/fetchAlgoliaResults.js
function _typeof22(obj) {
  "@babel/helpers - typeof";
  return _typeof22 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof22(obj);
}
var _excluded9 = ["params"];
function ownKeys20(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread20(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys20(Object(source), true).forEach(function(key) {
      _defineProperty20(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys20(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty20(obj, key, value) {
  key = _toPropertyKey20(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey20(arg) {
  var key = _toPrimitive20(arg, "string");
  return _typeof22(key) === "symbol" ? key : String(key);
}
function _toPrimitive20(input, hint) {
  if (_typeof22(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof22(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _objectWithoutProperties7(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose7(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose7(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function _toConsumableArray9(arr) {
  return _arrayWithoutHoles9(arr) || _iterableToArray9(arr) || _unsupportedIterableToArray13(arr) || _nonIterableSpread9();
}
function _nonIterableSpread9() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray13(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray13(o2, minLen);
  var n3 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n3 === "Object" && o2.constructor) n3 = o2.constructor.name;
  if (n3 === "Map" || n3 === "Set") return Array.from(o2);
  if (n3 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n3)) return _arrayLikeToArray13(o2, minLen);
}
function _iterableToArray9(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _arrayWithoutHoles9(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray13(arr);
}
function _arrayLikeToArray13(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++) arr2[i2] = arr[i2];
  return arr2;
}
function fetchAlgoliaResults(_ref) {
  var searchClient = _ref.searchClient, queries = _ref.queries, _ref$userAgents = _ref.userAgents, userAgents3 = _ref$userAgents === void 0 ? [] : _ref$userAgents;
  if (typeof searchClient.addAlgoliaAgent === "function") {
    var algoliaAgents = [].concat(_toConsumableArray9(userAgents), _toConsumableArray9(userAgents3));
    algoliaAgents.forEach(function(_ref2) {
      var segment = _ref2.segment, version3 = _ref2.version;
      searchClient.addAlgoliaAgent(segment, version3);
    });
  }
  var _getAppIdAndApiKey = getAppIdAndApiKey(searchClient), appId = _getAppIdAndApiKey.appId, apiKey = _getAppIdAndApiKey.apiKey;
  invariant(Boolean(appId), "The Algolia `appId` was not accessible from the searchClient passed.");
  invariant(Boolean(apiKey), "The Algolia `apiKey` was not accessible from the searchClient passed.");
  return searchClient.search(queries.map(function(searchParameters) {
    var params = searchParameters.params, headers = _objectWithoutProperties7(searchParameters, _excluded9);
    return _objectSpread20(_objectSpread20({}, headers), {}, {
      params: _objectSpread20({
        hitsPerPage: 5,
        highlightPreTag: HIGHLIGHT_PRE_TAG,
        highlightPostTag: HIGHLIGHT_POST_TAG
      }, params)
    });
  })).then(function(response) {
    return response.results.map(function(result, resultIndex) {
      var _result$hits;
      return _objectSpread20(_objectSpread20({}, result), {}, {
        hits: (_result$hits = result.hits) === null || _result$hits === void 0 ? void 0 : _result$hits.map(function(hit) {
          return _objectSpread20(_objectSpread20({}, hit), {}, {
            // Bring support for the Insights plugin.
            __autocomplete_indexName: result.index || queries[resultIndex].indexName,
            __autocomplete_queryID: result.queryID,
            __autocomplete_algoliaCredentials: {
              appId,
              apiKey
            }
          });
        })
      });
    });
  });
}

// node_modules/@algolia/autocomplete-preset-algolia/dist/esm/requester/createAlgoliaRequester.js
var createAlgoliaRequester = createRequester(fetchAlgoliaResults, "algolia");

// node_modules/@algolia/autocomplete-js/dist/esm/components/Highlight.js
function createHighlightComponent(_ref) {
  var createElement = _ref.createElement, Fragment = _ref.Fragment;
  function Highlight(_ref2) {
    var hit = _ref2.hit, attribute = _ref2.attribute, _ref2$tagName = _ref2.tagName, tagName = _ref2$tagName === void 0 ? "mark" : _ref2$tagName;
    return createElement(Fragment, {}, parseAlgoliaHitHighlight({
      hit,
      attribute
    }).map(function(x2, index) {
      return x2.isHighlighted ? createElement(tagName, {
        key: index
      }, x2.value) : x2.value;
    }));
  }
  Highlight.__autocomplete_componentName = "Highlight";
  return Highlight;
}

// node_modules/@algolia/autocomplete-js/dist/esm/components/ReverseHighlight.js
function createReverseHighlightComponent(_ref) {
  var createElement = _ref.createElement, Fragment = _ref.Fragment;
  function ReverseHighlight(_ref2) {
    var hit = _ref2.hit, attribute = _ref2.attribute, _ref2$tagName = _ref2.tagName, tagName = _ref2$tagName === void 0 ? "mark" : _ref2$tagName;
    return createElement(Fragment, {}, parseAlgoliaHitReverseHighlight({
      hit,
      attribute
    }).map(function(x2, index) {
      return x2.isHighlighted ? createElement(tagName, {
        key: index
      }, x2.value) : x2.value;
    }));
  }
  ReverseHighlight.__autocomplete_componentName = "ReverseHighlight";
  return ReverseHighlight;
}

// node_modules/@algolia/autocomplete-js/dist/esm/components/ReverseSnippet.js
function createReverseSnippetComponent(_ref) {
  var createElement = _ref.createElement, Fragment = _ref.Fragment;
  function ReverseSnippet(_ref2) {
    var hit = _ref2.hit, attribute = _ref2.attribute, _ref2$tagName = _ref2.tagName, tagName = _ref2$tagName === void 0 ? "mark" : _ref2$tagName;
    return createElement(Fragment, {}, parseAlgoliaHitReverseSnippet({
      hit,
      attribute
    }).map(function(x2, index) {
      return x2.isHighlighted ? createElement(tagName, {
        key: index
      }, x2.value) : x2.value;
    }));
  }
  ReverseSnippet.__autocomplete_componentName = "ReverseSnippet";
  return ReverseSnippet;
}

// node_modules/@algolia/autocomplete-js/dist/esm/components/Snippet.js
function createSnippetComponent(_ref) {
  var createElement = _ref.createElement, Fragment = _ref.Fragment;
  function Snippet(_ref2) {
    var hit = _ref2.hit, attribute = _ref2.attribute, _ref2$tagName = _ref2.tagName, tagName = _ref2$tagName === void 0 ? "mark" : _ref2$tagName;
    return createElement(Fragment, {}, parseAlgoliaHitSnippet({
      hit,
      attribute
    }).map(function(x2, index) {
      return x2.isHighlighted ? createElement(tagName, {
        key: index
      }, x2.value) : x2.value;
    }));
  }
  Snippet.__autocomplete_componentName = "Snippet";
  return Snippet;
}

// node_modules/@algolia/autocomplete-js/dist/esm/getDefaultOptions.js
function _typeof23(obj) {
  "@babel/helpers - typeof";
  return _typeof23 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof23(obj);
}
var _excluded10 = ["classNames", "container", "getEnvironmentProps", "getFormProps", "getInputProps", "getItemProps", "getLabelProps", "getListProps", "getPanelProps", "getRootProps", "panelContainer", "panelPlacement", "render", "renderNoResults", "renderer", "detachedMediaQuery", "components", "translations"];
function ownKeys21(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread21(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys21(Object(source), true).forEach(function(key) {
      _defineProperty21(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys21(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty21(obj, key, value) {
  key = _toPropertyKey21(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey21(arg) {
  var key = _toPrimitive21(arg, "string");
  return _typeof23(key) === "symbol" ? key : String(key);
}
function _toPrimitive21(input, hint) {
  if (_typeof23(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof23(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _objectWithoutProperties8(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose8(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose8(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
var defaultClassNames = {
  clearButton: "aa-ClearButton",
  detachedCancelButton: "aa-DetachedCancelButton",
  detachedContainer: "aa-DetachedContainer",
  detachedFormContainer: "aa-DetachedFormContainer",
  detachedOverlay: "aa-DetachedOverlay",
  detachedSearchButton: "aa-DetachedSearchButton",
  detachedSearchButtonIcon: "aa-DetachedSearchButtonIcon",
  detachedSearchButtonPlaceholder: "aa-DetachedSearchButtonPlaceholder",
  detachedSearchButtonQuery: "aa-DetachedSearchButtonQuery",
  form: "aa-Form",
  input: "aa-Input",
  inputWrapper: "aa-InputWrapper",
  inputWrapperPrefix: "aa-InputWrapperPrefix",
  inputWrapperSuffix: "aa-InputWrapperSuffix",
  item: "aa-Item",
  label: "aa-Label",
  list: "aa-List",
  loadingIndicator: "aa-LoadingIndicator",
  panel: "aa-Panel",
  panelLayout: "aa-PanelLayout aa-Panel--scrollable",
  root: "aa-Autocomplete",
  source: "aa-Source",
  sourceFooter: "aa-SourceFooter",
  sourceHeader: "aa-SourceHeader",
  sourceNoResults: "aa-SourceNoResults",
  submitButton: "aa-SubmitButton"
};
var defaultRender = function defaultRender2(_ref, root) {
  var children = _ref.children, render = _ref.render;
  render(children, root);
};
var defaultRenderer = {
  createElement: _,
  Fragment: k,
  render: E
};
function getDefaultOptions(options) {
  var _core$id;
  var classNames = options.classNames, container = options.container, getEnvironmentProps = options.getEnvironmentProps, getFormProps = options.getFormProps, getInputProps = options.getInputProps, getItemProps = options.getItemProps, getLabelProps = options.getLabelProps, getListProps = options.getListProps, getPanelProps = options.getPanelProps, getRootProps = options.getRootProps, panelContainer = options.panelContainer, panelPlacement = options.panelPlacement, render = options.render, renderNoResults = options.renderNoResults, renderer = options.renderer, detachedMediaQuery = options.detachedMediaQuery, components = options.components, translations = options.translations, core = _objectWithoutProperties8(options, _excluded10);
  var environment = typeof window !== "undefined" ? window : {};
  var containerElement = getHTMLElement(environment, container);
  invariant(containerElement.tagName !== "INPUT", "The `container` option does not support `input` elements. You need to change the container to a `div`.");
  true ? warn(!(render && renderer && !(renderer !== null && renderer !== void 0 && renderer.render)), "You provided the `render` option but did not provide a `renderer.render`. Since v1.6.0, you can provide a `render` function directly in `renderer`.\nTo get rid of this warning, do any of the following depending on your use case.\n- If you are using the `render` option only to override Autocomplete's default `render` function, pass the `render` function into `renderer` and remove the `render` option.\n- If you are using the `render` option to customize the layout, pass your `render` function into `renderer` and use it from the provided parameters of the `render` option.\n- If you are using the `render` option to work with React 18, pass an empty `render` function into `renderer`.\nSee https://www.algolia.com/doc/ui-libraries/autocomplete/api-reference/autocomplete-js/autocomplete/#param-render") : void 0;
  true ? warn(!renderer || render || renderer.Fragment && renderer.createElement && renderer.render, "You provided an incomplete `renderer` (missing: ".concat([!(renderer !== null && renderer !== void 0 && renderer.createElement) && "`renderer.createElement`", !(renderer !== null && renderer !== void 0 && renderer.Fragment) && "`renderer.Fragment`", !(renderer !== null && renderer !== void 0 && renderer.render) && "`renderer.render`"].filter(Boolean).join(", "), "). This can cause rendering issues.") + "\nSee https://www.algolia.com/doc/ui-libraries/autocomplete/api-reference/autocomplete-js/autocomplete/#param-renderer") : void 0;
  var defaultedRenderer = _objectSpread21(_objectSpread21({}, defaultRenderer), renderer);
  var defaultComponents = {
    Highlight: createHighlightComponent(defaultedRenderer),
    ReverseHighlight: createReverseHighlightComponent(defaultedRenderer),
    ReverseSnippet: createReverseSnippetComponent(defaultedRenderer),
    Snippet: createSnippetComponent(defaultedRenderer)
  };
  var defaultTranslations = {
    clearButtonTitle: "Clear",
    detachedCancelButtonText: "Cancel",
    detachedSearchButtonTitle: "Search",
    submitButtonTitle: "Submit"
  };
  return {
    renderer: {
      classNames: mergeClassNames(defaultClassNames, classNames !== null && classNames !== void 0 ? classNames : {}),
      container: containerElement,
      getEnvironmentProps: getEnvironmentProps !== null && getEnvironmentProps !== void 0 ? getEnvironmentProps : function(_ref2) {
        var props = _ref2.props;
        return props;
      },
      getFormProps: getFormProps !== null && getFormProps !== void 0 ? getFormProps : function(_ref3) {
        var props = _ref3.props;
        return props;
      },
      getInputProps: getInputProps !== null && getInputProps !== void 0 ? getInputProps : function(_ref4) {
        var props = _ref4.props;
        return props;
      },
      getItemProps: getItemProps !== null && getItemProps !== void 0 ? getItemProps : function(_ref5) {
        var props = _ref5.props;
        return props;
      },
      getLabelProps: getLabelProps !== null && getLabelProps !== void 0 ? getLabelProps : function(_ref6) {
        var props = _ref6.props;
        return props;
      },
      getListProps: getListProps !== null && getListProps !== void 0 ? getListProps : function(_ref7) {
        var props = _ref7.props;
        return props;
      },
      getPanelProps: getPanelProps !== null && getPanelProps !== void 0 ? getPanelProps : function(_ref8) {
        var props = _ref8.props;
        return props;
      },
      getRootProps: getRootProps !== null && getRootProps !== void 0 ? getRootProps : function(_ref9) {
        var props = _ref9.props;
        return props;
      },
      panelContainer: panelContainer ? getHTMLElement(environment, panelContainer) : environment.document.body,
      panelPlacement: panelPlacement !== null && panelPlacement !== void 0 ? panelPlacement : "input-wrapper-width",
      render: render !== null && render !== void 0 ? render : defaultRender,
      renderNoResults,
      renderer: defaultedRenderer,
      detachedMediaQuery: detachedMediaQuery !== null && detachedMediaQuery !== void 0 ? detachedMediaQuery : getComputedStyle(environment.document.documentElement).getPropertyValue("--aa-detached-media-query"),
      components: _objectSpread21(_objectSpread21({}, defaultComponents), components),
      translations: _objectSpread21(_objectSpread21({}, defaultTranslations), translations)
    },
    core: _objectSpread21(_objectSpread21({}, core), {}, {
      id: (_core$id = core.id) !== null && _core$id !== void 0 ? _core$id : generateAutocompleteId(),
      environment
    })
  };
}

// node_modules/@algolia/autocomplete-js/dist/esm/getPanelPlacementStyle.js
function getPanelPlacementStyle(_ref) {
  var panelPlacement = _ref.panelPlacement, container = _ref.container, form = _ref.form, environment = _ref.environment;
  var containerRect = container.getBoundingClientRect();
  var scrollTop = environment.pageYOffset || environment.document.documentElement.scrollTop || environment.document.body.scrollTop || 0;
  var top = scrollTop + containerRect.top + containerRect.height;
  switch (panelPlacement) {
    case "start": {
      return {
        top,
        left: containerRect.left
      };
    }
    case "end": {
      return {
        top,
        right: environment.document.documentElement.clientWidth - (containerRect.left + containerRect.width)
      };
    }
    case "full-width": {
      return {
        top,
        left: 0,
        right: 0,
        width: "unset",
        maxWidth: "unset"
      };
    }
    case "input-wrapper-width": {
      var formRect = form.getBoundingClientRect();
      return {
        top,
        left: formRect.left,
        right: environment.document.documentElement.clientWidth - (formRect.left + formRect.width),
        width: "unset",
        maxWidth: "unset"
      };
    }
    default: {
      throw new Error("[Autocomplete] The `panelPlacement` value ".concat(JSON.stringify(panelPlacement), " is not valid."));
    }
  }
}

// node_modules/@algolia/autocomplete-js/dist/esm/render.js
function _typeof24(obj) {
  "@babel/helpers - typeof";
  return _typeof24 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof24(obj);
}
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = arguments[i2];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function ownKeys22(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread22(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys22(Object(source), true).forEach(function(key) {
      _defineProperty22(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys22(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty22(obj, key, value) {
  key = _toPropertyKey22(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey22(arg) {
  var key = _toPrimitive22(arg, "string");
  return _typeof24(key) === "symbol" ? key : String(key);
}
function _toPrimitive22(input, hint) {
  if (_typeof24(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof24(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function renderSearchBox(_ref) {
  var autocomplete2 = _ref.autocomplete, autocompleteScopeApi = _ref.autocompleteScopeApi, dom = _ref.dom, propGetters = _ref.propGetters, state = _ref.state;
  setPropertiesWithoutEvents(dom.root, propGetters.getRootProps(_objectSpread22({
    state,
    props: autocomplete2.getRootProps({})
  }, autocompleteScopeApi)));
  setPropertiesWithoutEvents(dom.input, propGetters.getInputProps(_objectSpread22({
    state,
    props: autocomplete2.getInputProps({
      inputElement: dom.input
    }),
    inputElement: dom.input
  }, autocompleteScopeApi)));
  setProperties(dom.label, {
    hidden: state.status === "stalled"
  });
  setProperties(dom.loadingIndicator, {
    hidden: state.status !== "stalled"
  });
  setProperties(dom.clearButton, {
    hidden: !state.query
  });
  setProperties(dom.detachedSearchButtonQuery, {
    textContent: state.query
  });
  setProperties(dom.detachedSearchButtonPlaceholder, {
    hidden: Boolean(state.query)
  });
}
function renderPanel(render, _ref2) {
  var autocomplete2 = _ref2.autocomplete, autocompleteScopeApi = _ref2.autocompleteScopeApi, classNames = _ref2.classNames, html = _ref2.html, dom = _ref2.dom, panelContainer = _ref2.panelContainer, propGetters = _ref2.propGetters, state = _ref2.state, components = _ref2.components, renderer = _ref2.renderer;
  if (!state.isOpen) {
    if (panelContainer.contains(dom.panel)) {
      panelContainer.removeChild(dom.panel);
    }
    return;
  }
  if (!panelContainer.contains(dom.panel) && state.status !== "loading") {
    panelContainer.appendChild(dom.panel);
  }
  dom.panel.classList.toggle("aa-Panel--stalled", state.status === "stalled");
  var sections = state.collections.filter(function(_ref3) {
    var source = _ref3.source, items = _ref3.items;
    return source.templates.noResults || items.length > 0;
  }).map(function(_ref4, sourceIndex) {
    var source = _ref4.source, items = _ref4.items;
    return renderer.createElement("section", {
      key: sourceIndex,
      className: classNames.source,
      "data-autocomplete-source-id": source.sourceId
    }, source.templates.header && renderer.createElement("div", {
      className: classNames.sourceHeader
    }, source.templates.header({
      components,
      createElement: renderer.createElement,
      Fragment: renderer.Fragment,
      items,
      source,
      state,
      html
    })), source.templates.noResults && items.length === 0 ? renderer.createElement("div", {
      className: classNames.sourceNoResults
    }, source.templates.noResults({
      components,
      createElement: renderer.createElement,
      Fragment: renderer.Fragment,
      source,
      state,
      html
    })) : renderer.createElement("ul", _extends({
      className: classNames.list
    }, propGetters.getListProps(_objectSpread22({
      state,
      props: autocomplete2.getListProps({
        source
      })
    }, autocompleteScopeApi))), items.map(function(item) {
      var itemProps = autocomplete2.getItemProps({
        item,
        source
      });
      return renderer.createElement("li", _extends({
        key: itemProps.id,
        className: classNames.item
      }, propGetters.getItemProps(_objectSpread22({
        state,
        props: itemProps
      }, autocompleteScopeApi))), source.templates.item({
        components,
        createElement: renderer.createElement,
        Fragment: renderer.Fragment,
        item,
        state,
        html
      }));
    })), source.templates.footer && renderer.createElement("div", {
      className: classNames.sourceFooter
    }, source.templates.footer({
      components,
      createElement: renderer.createElement,
      Fragment: renderer.Fragment,
      items,
      source,
      state,
      html
    })));
  });
  var children = renderer.createElement(renderer.Fragment, null, renderer.createElement("div", {
    className: classNames.panelLayout
  }, sections), renderer.createElement("div", {
    className: "aa-GradientBottom"
  }));
  var elements = sections.reduce(function(acc, current) {
    acc[current.props["data-autocomplete-source-id"]] = current;
    return acc;
  }, {});
  render(_objectSpread22(_objectSpread22({
    children,
    state,
    sections,
    elements
  }, renderer), {}, {
    components,
    html
  }, autocompleteScopeApi), dom.panel);
}

// node_modules/@algolia/autocomplete-js/dist/esm/userAgents.js
var userAgents2 = [{
  segment: "autocomplete-js",
  version: version2
}];

// node_modules/@algolia/autocomplete-js/dist/esm/autocomplete.js
var _excluded11 = ["components"];
function _typeof25(obj) {
  "@babel/helpers - typeof";
  return _typeof25 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof25(obj);
}
function _objectWithoutProperties9(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose9(source, excluded);
  var key, i2;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
      key = sourceSymbolKeys[i2];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose9(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function ownKeys23(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread23(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys23(Object(source), true).forEach(function(key) {
      _defineProperty23(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys23(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty23(obj, key, value) {
  key = _toPropertyKey23(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey23(arg) {
  var key = _toPrimitive23(arg, "string");
  return _typeof25(key) === "symbol" ? key : String(key);
}
function _toPrimitive23(input, hint) {
  if (_typeof25(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof25(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var instancesCount = 0;
function autocomplete(options) {
  var _createEffectWrapper = createEffectWrapper(), runEffect = _createEffectWrapper.runEffect, cleanupEffects = _createEffectWrapper.cleanupEffects, runEffects = _createEffectWrapper.runEffects;
  var _createReactiveWrappe = createReactiveWrapper(), reactive = _createReactiveWrappe.reactive, runReactives = _createReactiveWrappe.runReactives;
  var hasNoResultsSourceTemplateRef = createRef2(false);
  var optionsRef = createRef2(options);
  var onStateChangeRef = createRef2(void 0);
  var props = reactive(function() {
    return getDefaultOptions(optionsRef.current);
  });
  var isDetached = reactive(function() {
    return props.value.core.environment.matchMedia(props.value.renderer.detachedMediaQuery).matches;
  });
  var autocomplete2 = reactive(function() {
    return createAutocomplete(_objectSpread23(_objectSpread23({}, props.value.core), {}, {
      onStateChange: function onStateChange(params) {
        var _onStateChangeRef$cur, _props$value$core$onS, _props$value$core;
        hasNoResultsSourceTemplateRef.current = params.state.collections.some(function(collection) {
          return collection.source.templates.noResults;
        });
        (_onStateChangeRef$cur = onStateChangeRef.current) === null || _onStateChangeRef$cur === void 0 ? void 0 : _onStateChangeRef$cur.call(onStateChangeRef, params);
        (_props$value$core$onS = (_props$value$core = props.value.core).onStateChange) === null || _props$value$core$onS === void 0 ? void 0 : _props$value$core$onS.call(_props$value$core, params);
      },
      shouldPanelOpen: optionsRef.current.shouldPanelOpen || function(_ref) {
        var state = _ref.state;
        if (isDetached.value) {
          return true;
        }
        var hasItems = getItemsCount(state) > 0;
        if (!props.value.core.openOnFocus && !state.query) {
          return hasItems;
        }
        var hasNoResultsTemplate = Boolean(hasNoResultsSourceTemplateRef.current || props.value.renderer.renderNoResults);
        return !hasItems && hasNoResultsTemplate || hasItems;
      },
      __autocomplete_metadata: {
        userAgents: userAgents2,
        options
      }
    }));
  });
  var lastStateRef = createRef2(_objectSpread23({
    collections: [],
    completion: null,
    context: {},
    isOpen: false,
    query: "",
    activeItemId: null,
    status: "idle"
  }, props.value.core.initialState));
  var propGetters = {
    getEnvironmentProps: props.value.renderer.getEnvironmentProps,
    getFormProps: props.value.renderer.getFormProps,
    getInputProps: props.value.renderer.getInputProps,
    getItemProps: props.value.renderer.getItemProps,
    getLabelProps: props.value.renderer.getLabelProps,
    getListProps: props.value.renderer.getListProps,
    getPanelProps: props.value.renderer.getPanelProps,
    getRootProps: props.value.renderer.getRootProps
  };
  var autocompleteScopeApi = {
    setActiveItemId: autocomplete2.value.setActiveItemId,
    setQuery: autocomplete2.value.setQuery,
    setCollections: autocomplete2.value.setCollections,
    setIsOpen: autocomplete2.value.setIsOpen,
    setStatus: autocomplete2.value.setStatus,
    setContext: autocomplete2.value.setContext,
    refresh: autocomplete2.value.refresh,
    navigator: autocomplete2.value.navigator
  };
  var html = reactive(function() {
    return htm_module_default.bind(props.value.renderer.renderer.createElement);
  });
  var dom = reactive(function() {
    return createAutocompleteDom({
      autocomplete: autocomplete2.value,
      autocompleteScopeApi,
      classNames: props.value.renderer.classNames,
      environment: props.value.core.environment,
      isDetached: isDetached.value,
      placeholder: props.value.core.placeholder,
      propGetters,
      setIsModalOpen,
      state: lastStateRef.current,
      translations: props.value.renderer.translations
    });
  });
  function setPanelPosition() {
    setProperties(dom.value.panel, {
      style: isDetached.value ? {} : getPanelPlacementStyle({
        panelPlacement: props.value.renderer.panelPlacement,
        container: dom.value.root,
        form: dom.value.form,
        environment: props.value.core.environment
      })
    });
  }
  function scheduleRender(state) {
    lastStateRef.current = state;
    var renderProps = {
      autocomplete: autocomplete2.value,
      autocompleteScopeApi,
      classNames: props.value.renderer.classNames,
      components: props.value.renderer.components,
      container: props.value.renderer.container,
      html: html.value,
      dom: dom.value,
      panelContainer: isDetached.value ? dom.value.detachedContainer : props.value.renderer.panelContainer,
      propGetters,
      state: lastStateRef.current,
      renderer: props.value.renderer.renderer
    };
    var render = !getItemsCount(state) && !hasNoResultsSourceTemplateRef.current && props.value.renderer.renderNoResults || props.value.renderer.render;
    renderSearchBox(renderProps);
    renderPanel(render, renderProps);
  }
  runEffect(function() {
    var environmentProps = autocomplete2.value.getEnvironmentProps({
      formElement: dom.value.form,
      panelElement: dom.value.panel,
      inputElement: dom.value.input
    });
    setProperties(props.value.core.environment, environmentProps);
    return function() {
      setProperties(props.value.core.environment, Object.keys(environmentProps).reduce(function(acc, key) {
        return _objectSpread23(_objectSpread23({}, acc), {}, _defineProperty23({}, key, void 0));
      }, {}));
    };
  });
  runEffect(function() {
    var panelContainerElement = isDetached.value ? props.value.core.environment.document.body : props.value.renderer.panelContainer;
    var panelElement = isDetached.value ? dom.value.detachedOverlay : dom.value.panel;
    if (isDetached.value && lastStateRef.current.isOpen) {
      setIsModalOpen(true);
    }
    scheduleRender(lastStateRef.current);
    return function() {
      if (panelContainerElement.contains(panelElement)) {
        panelContainerElement.removeChild(panelElement);
        panelContainerElement.classList.remove("aa-Detached");
      }
    };
  });
  runEffect(function() {
    var containerElement = props.value.renderer.container;
    containerElement.appendChild(dom.value.root);
    return function() {
      containerElement.removeChild(dom.value.root);
    };
  });
  runEffect(function() {
    var debouncedRender = debounce2(function(_ref2) {
      var state = _ref2.state;
      scheduleRender(state);
    }, 0);
    onStateChangeRef.current = function(_ref3) {
      var state = _ref3.state, prevState = _ref3.prevState;
      if (isDetached.value && prevState.isOpen !== state.isOpen) {
        setIsModalOpen(state.isOpen);
      }
      if (!isDetached.value && state.isOpen && !prevState.isOpen) {
        setPanelPosition();
      }
      if (state.query !== prevState.query) {
        var scrollablePanels = props.value.core.environment.document.querySelectorAll(".aa-Panel--scrollable");
        scrollablePanels.forEach(function(scrollablePanel) {
          if (scrollablePanel.scrollTop !== 0) {
            scrollablePanel.scrollTop = 0;
          }
        });
      }
      debouncedRender({
        state
      });
    };
    return function() {
      onStateChangeRef.current = void 0;
    };
  });
  runEffect(function() {
    var onResize = debounce2(function() {
      var previousIsDetached = isDetached.value;
      isDetached.value = props.value.core.environment.matchMedia(props.value.renderer.detachedMediaQuery).matches;
      if (previousIsDetached !== isDetached.value) {
        update({});
      } else {
        requestAnimationFrame(setPanelPosition);
      }
    }, 20);
    props.value.core.environment.addEventListener("resize", onResize);
    return function() {
      props.value.core.environment.removeEventListener("resize", onResize);
    };
  });
  runEffect(function() {
    if (!isDetached.value) {
      return function() {
      };
    }
    function toggleModalClassname(isActive) {
      dom.value.detachedContainer.classList.toggle("aa-DetachedContainer--modal", isActive);
    }
    function onChange(event) {
      toggleModalClassname(event.matches);
    }
    var isModalDetachedMql = props.value.core.environment.matchMedia(getComputedStyle(props.value.core.environment.document.documentElement).getPropertyValue("--aa-detached-modal-media-query"));
    toggleModalClassname(isModalDetachedMql.matches);
    var hasModernEventListener = Boolean(isModalDetachedMql.addEventListener);
    hasModernEventListener ? isModalDetachedMql.addEventListener("change", onChange) : isModalDetachedMql.addListener(onChange);
    return function() {
      hasModernEventListener ? isModalDetachedMql.removeEventListener("change", onChange) : isModalDetachedMql.removeListener(onChange);
    };
  });
  runEffect(function() {
    requestAnimationFrame(setPanelPosition);
    return function() {
    };
  });
  function destroy() {
    instancesCount--;
    cleanupEffects();
  }
  function update() {
    var updatedOptions = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    cleanupEffects();
    var _props$value$renderer = props.value.renderer, components = _props$value$renderer.components, rendererProps = _objectWithoutProperties9(_props$value$renderer, _excluded11);
    optionsRef.current = mergeDeep(rendererProps, props.value.core, {
      // We need to filter out default components so they can be replaced with
      // a new `renderer`, without getting rid of user components.
      // @MAJOR Deal with registering components with the same name as the
      // default ones. If we disallow overriding default components, we'd just
      // need to pass all `components` here.
      components: pickBy(components, function(_ref4) {
        var value = _ref4.value;
        return !value.hasOwnProperty("__autocomplete_componentName");
      }),
      initialState: lastStateRef.current
    }, updatedOptions);
    runReactives();
    runEffects();
    autocomplete2.value.refresh().then(function() {
      scheduleRender(lastStateRef.current);
    });
  }
  function setIsModalOpen(value) {
    var prevValue = props.value.core.environment.document.body.contains(dom.value.detachedOverlay);
    if (value === prevValue) {
      return;
    }
    if (value) {
      props.value.core.environment.document.body.appendChild(dom.value.detachedOverlay);
      props.value.core.environment.document.body.classList.add("aa-Detached");
      dom.value.input.focus();
    } else {
      props.value.core.environment.document.body.removeChild(dom.value.detachedOverlay);
      props.value.core.environment.document.body.classList.remove("aa-Detached");
    }
  }
  true ? warn(instancesCount === 0, "Autocomplete doesn't support multiple instances running at the same time. Make sure to destroy the previous instance before creating a new one.\n\nSee: https://www.algolia.com/doc/ui-libraries/autocomplete/api-reference/autocomplete-js/autocomplete/#param-destroy") : void 0;
  instancesCount++;
  return _objectSpread23(_objectSpread23({}, autocompleteScopeApi), {}, {
    update,
    destroy
  });
}

// node_modules/@algolia/autocomplete-js/dist/esm/requesters/createAlgoliaRequester.js
function _typeof26(obj) {
  "@babel/helpers - typeof";
  return _typeof26 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof26(obj);
}
function ownKeys24(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread24(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys24(Object(source), true).forEach(function(key) {
      _defineProperty24(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys24(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty24(obj, key, value) {
  key = _toPropertyKey24(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey24(arg) {
  var key = _toPrimitive24(arg, "string");
  return _typeof26(key) === "symbol" ? key : String(key);
}
function _toPrimitive24(input, hint) {
  if (_typeof26(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof26(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var createAlgoliaRequester2 = createRequester(function(params) {
  return fetchAlgoliaResults(_objectSpread24(_objectSpread24({}, params), {}, {
    userAgents: userAgents2
  }));
}, "algolia");

// node_modules/@algolia/autocomplete-js/dist/esm/requesters/getAlgoliaFacets.js
function _typeof27(obj) {
  "@babel/helpers - typeof";
  return _typeof27 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof27(obj);
}
function ownKeys25(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread25(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys25(Object(source), true).forEach(function(key) {
      _defineProperty25(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys25(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty25(obj, key, value) {
  key = _toPropertyKey25(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey25(arg) {
  var key = _toPrimitive25(arg, "string");
  return _typeof27(key) === "symbol" ? key : String(key);
}
function _toPrimitive25(input, hint) {
  if (_typeof27(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof27(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function getAlgoliaFacets(requestParams) {
  var requester = createAlgoliaRequester2({
    transformResponse: function transformResponse2(response) {
      return response.facetHits;
    }
  });
  var queries = requestParams.queries.map(function(query) {
    return _objectSpread25(_objectSpread25({}, query), {}, {
      type: "facet"
    });
  });
  return requester(_objectSpread25(_objectSpread25({}, requestParams), {}, {
    queries
  }));
}

// node_modules/@algolia/autocomplete-js/dist/esm/requesters/getAlgoliaResults.js
var getAlgoliaResults = createAlgoliaRequester2({
  transformResponse: function transformResponse(response) {
    return response.hits;
  }
});
export {
  autocomplete,
  getAlgoliaFacets,
  getAlgoliaResults
};
//# sourceMappingURL=@algolia_autocomplete-js.js.map
