import {
  dataTables_bootstrap5_default
} from "./chunk-N7TSZCXM.js";
import {
  dataTables_default
} from "./chunk-Y4QPKPQ6.js";
import {
  require_jquery
} from "./chunk-W7XVOHYT.js";
import {
  __toESM
} from "./chunk-LK32TJAX.js";

// node_modules/datatables.net-fixedcolumns-bs5/js/fixedColumns.bootstrap5.mjs
var import_jquery2 = __toESM(require_jquery(), 1);

// node_modules/datatables.net-fixedcolumns/js/dataTables.fixedColumns.mjs
var import_jquery = __toESM(require_jquery(), 1);
var $ = import_jquery.default;
(function() {
  "use strict";
  var $$1;
  var DataTable$1;
  function setJQuery(jq) {
    $$1 = jq;
    DataTable$1 = $$1.fn.dataTable;
  }
  var FixedColumns = (
    /** @class */
    function() {
      function FixedColumns2(settings, opts) {
        var _this = this;
        if (!DataTable$1 || !DataTable$1.versionCheck || !DataTable$1.versionCheck("2")) {
          throw new Error("FixedColumns requires DataTables 2 or newer");
        }
        var table = new DataTable$1.Api(settings);
        this.classes = $$1.extend(true, {}, FixedColumns2.classes);
        this.c = $$1.extend(true, {}, FixedColumns2.defaults, opts);
        this.s = {
          dt: table,
          rtl: $$1(table.table().node()).css("direction") === "rtl"
        };
        if (opts && opts.leftColumns !== void 0) {
          opts.left = opts.leftColumns;
        }
        if (opts && opts.left !== void 0) {
          this.c[this.s.rtl ? "end" : "start"] = opts.left;
        }
        if (opts && opts.rightColumns !== void 0) {
          opts.right = opts.rightColumns;
        }
        if (opts && opts.right !== void 0) {
          this.c[this.s.rtl ? "start" : "end"] = opts.right;
        }
        this.dom = {
          bottomBlocker: $$1("<div>").addClass(this.classes.bottomBlocker),
          topBlocker: $$1("<div>").addClass(this.classes.topBlocker),
          scroller: $$1("div.dt-scroll-body", this.s.dt.table().container())
        };
        if (this.s.dt.settings()[0]._bInitComplete) {
          this._addStyles();
          this._setKeyTableListener();
        } else {
          table.one("init.dt.dtfc", function() {
            _this._addStyles();
            _this._setKeyTableListener();
          });
        }
        table.on("column-sizing.dt.dtfc column-reorder.dt.dtfc draw.dt.dtfc", function() {
          return _this._addStyles();
        });
        var debounced = DataTable$1.util.debounce(function() {
          _this._addStyles();
        }, 50);
        table.on("column-visibility.dt.dtfc", function() {
          debounced();
        });
        this.dom.scroller.on("scroll.dtfc", function() {
          return _this._scroll();
        });
        this._scroll();
        table.settings()[0]._fixedColumns = this;
        table.on("destroy", function() {
          return _this._destroy();
        });
        return this;
      }
      FixedColumns2.prototype.end = function(newVal) {
        if (newVal !== void 0) {
          if (newVal >= 0 && newVal <= this.s.dt.columns().count()) {
            this.c.end = newVal;
            this._addStyles();
          }
          return this;
        }
        return this.c.end;
      };
      FixedColumns2.prototype.left = function(count) {
        return this.s.rtl ? this.end(count) : this.start(count);
      };
      FixedColumns2.prototype.right = function(count) {
        return this.s.rtl ? this.start(count) : this.end(count);
      };
      FixedColumns2.prototype.start = function(newVal) {
        if (newVal !== void 0) {
          if (newVal >= 0 && newVal <= this.s.dt.columns().count()) {
            this.c.start = newVal;
            this._addStyles();
          }
          return this;
        }
        return this.c.start;
      };
      FixedColumns2.prototype._addStyles = function() {
        var dt = this.s.dt;
        var that = this;
        var colCount = this.s.dt.columns(":visible").count();
        var headerStruct = dt.table().header.structure(":visible");
        var footerStruct = dt.table().footer.structure(":visible");
        var widths = dt.columns(":visible").widths().toArray();
        var wrapper = $$1(dt.table().node()).closest("div.dt-scroll");
        var scroller = $$1(dt.table().node()).closest("div.dt-scroll-body")[0];
        var rtl = this.s.rtl;
        var start = this.c.start;
        var end = this.c.end;
        var left = rtl ? end : start;
        var right = rtl ? start : end;
        var barWidth = dt.settings()[0].oBrowser.barWidth;
        if (wrapper.length === 0) {
          return this;
        }
        if (scroller.offsetWidth === scroller.clientWidth) {
          barWidth = 0;
        }
        dt.columns().every(function(colIdx) {
          var visIdx = dt.column.index("toVisible", colIdx);
          var offset;
          if (visIdx === null) {
            return;
          }
          if (visIdx < start) {
            offset = that._sum(widths, visIdx);
            that._fixColumn(visIdx, offset, "start", headerStruct, footerStruct, barWidth);
          } else if (visIdx >= colCount - end) {
            offset = that._sum(widths, colCount - visIdx - 1, true);
            that._fixColumn(visIdx, offset, "end", headerStruct, footerStruct, barWidth);
          } else {
            that._fixColumn(visIdx, 0, "none", headerStruct, footerStruct, barWidth);
          }
        });
        $$1(dt.table().node()).toggleClass(that.classes.tableFixedStart, start > 0).toggleClass(that.classes.tableFixedEnd, end > 0).toggleClass(that.classes.tableFixedLeft, left > 0).toggleClass(that.classes.tableFixedRight, right > 0);
        var headerEl = dt.table().header();
        var footerEl = dt.table().footer();
        var headerHeight = $$1(headerEl).outerHeight();
        var footerHeight = $$1(footerEl).outerHeight();
        this.dom.topBlocker.appendTo(wrapper).css("top", 0).css(this.s.rtl ? "left" : "right", 0).css("height", headerHeight).css("width", barWidth + 1).css("display", barWidth ? "block" : "none");
        if (footerEl) {
          this.dom.bottomBlocker.appendTo(wrapper).css("bottom", 0).css(this.s.rtl ? "left" : "right", 0).css("height", footerHeight).css("width", barWidth + 1).css("display", barWidth ? "block" : "none");
        }
      };
      FixedColumns2.prototype._destroy = function() {
        this.s.dt.off(".dtfc");
        this.dom.scroller.off(".dtfc");
        $$1(this.s.dt.table().node()).removeClass(this.classes.tableScrollingEnd + " " + this.classes.tableScrollingLeft + " " + this.classes.tableScrollingStart + " " + this.classes.tableScrollingRight);
        this.dom.bottomBlocker.remove();
        this.dom.topBlocker.remove();
      };
      FixedColumns2.prototype._fixColumn = function(idx, offset, side, header, footer, barWidth) {
        var _this = this;
        var dt = this.s.dt;
        var applyStyles = function(jq, part) {
          if (side === "none") {
            jq.css("position", "").css("left", "").css("right", "").removeClass(_this.classes.fixedEnd + " " + _this.classes.fixedLeft + " " + _this.classes.fixedRight + " " + _this.classes.fixedStart);
          } else {
            var positionSide = side === "start" ? "left" : "right";
            if (_this.s.rtl) {
              positionSide = side === "start" ? "right" : "left";
            }
            var off = offset;
            if (side === "end" && (part === "header" || part === "footer")) {
              off += barWidth;
            }
            jq.css("position", "sticky").css(positionSide, off).addClass(side === "start" ? _this.classes.fixedStart : _this.classes.fixedEnd).addClass(positionSide === "left" ? _this.classes.fixedLeft : _this.classes.fixedRight);
          }
        };
        header.forEach(function(row) {
          if (row[idx]) {
            applyStyles($$1(row[idx].cell), "header");
          }
        });
        applyStyles(dt.column(idx + ":visible", { page: "current" }).nodes().to$(), "body");
        if (footer) {
          footer.forEach(function(row) {
            if (row[idx]) {
              applyStyles($$1(row[idx].cell), "footer");
            }
          });
        }
      };
      FixedColumns2.prototype._scroll = function() {
        var scroller = this.dom.scroller[0];
        if (!scroller) {
          return;
        }
        var table = $$1(this.s.dt.table().node()).add(this.s.dt.table().header().parentNode).add(this.s.dt.table().footer().parentNode).add("div.dt-scroll-headInner table", this.s.dt.table().container()).add("div.dt-scroll-footInner table", this.s.dt.table().container());
        var scrollLeft = scroller.scrollLeft;
        var ltr = !this.s.rtl;
        var scrollStart = scrollLeft !== 0;
        var scrollEnd = scroller.scrollWidth > scroller.clientWidth + Math.abs(scrollLeft) + 1;
        table.toggleClass(this.classes.tableScrollingStart, scrollStart);
        table.toggleClass(this.classes.tableScrollingEnd, scrollEnd);
        table.toggleClass(this.classes.tableScrollingLeft, scrollStart && ltr || scrollEnd && !ltr);
        table.toggleClass(this.classes.tableScrollingRight, scrollEnd && ltr || scrollStart && !ltr);
      };
      FixedColumns2.prototype._setKeyTableListener = function() {
        var _this = this;
        this.s.dt.on("key-focus.dt.dtfc", function(e, dt, cell) {
          var currScroll;
          var cellPos = $$1(cell.node()).offset();
          var scroller = _this.dom.scroller[0];
          var scroll = $$1($$1(_this.s.dt.table().node()).closest("div.dt-scroll-body"));
          if (_this.c.start > 0) {
            var rightMost = $$1(_this.s.dt.column(_this.c.start - 1).header());
            var rightMostPos = rightMost.offset();
            var rightMostWidth = rightMost.outerWidth();
            if ($$1(cell.node()).hasClass(_this.classes.fixedLeft)) {
              scroll.scrollLeft(0);
            } else if (cellPos.left < rightMostPos.left + rightMostWidth) {
              currScroll = scroll.scrollLeft();
              scroll.scrollLeft(currScroll - (rightMostPos.left + rightMostWidth - cellPos.left));
            }
          }
          if (_this.c.end > 0) {
            var numCols = _this.s.dt.columns().data().toArray().length;
            var cellWidth = $$1(cell.node()).outerWidth();
            var leftMost = $$1(_this.s.dt.column(numCols - _this.c.end).header());
            var leftMostPos = leftMost.offset();
            if ($$1(cell.node()).hasClass(_this.classes.fixedRight)) {
              scroll.scrollLeft(scroller.scrollWidth - scroller.clientWidth);
            } else if (cellPos.left + cellWidth > leftMostPos.left) {
              currScroll = scroll.scrollLeft();
              scroll.scrollLeft(currScroll - (leftMostPos.left - (cellPos.left + cellWidth)));
            }
          }
        });
      };
      FixedColumns2.prototype._sum = function(widths, index, reverse) {
        if (reverse === void 0) {
          reverse = false;
        }
        if (reverse) {
          widths = widths.slice().reverse();
        }
        return widths.slice(0, index).reduce(function(accum, val) {
          return accum + val;
        }, 0);
      };
      FixedColumns2.version = "5.0.4";
      FixedColumns2.classes = {
        bottomBlocker: "dtfc-bottom-blocker",
        fixedEnd: "dtfc-fixed-end",
        fixedLeft: "dtfc-fixed-left",
        fixedRight: "dtfc-fixed-right",
        fixedStart: "dtfc-fixed-start",
        tableFixedEnd: "dtfc-has-end",
        tableFixedLeft: "dtfc-has-left",
        tableFixedRight: "dtfc-has-right",
        tableFixedStart: "dtfc-has-start",
        tableScrollingEnd: "dtfc-scrolling-end",
        tableScrollingLeft: "dtfc-scrolling-left",
        tableScrollingRight: "dtfc-scrolling-right",
        tableScrollingStart: "dtfc-scrolling-start",
        topBlocker: "dtfc-top-blocker"
      };
      FixedColumns2.defaults = {
        i18n: {
          button: "FixedColumns"
        },
        start: 1,
        end: 0
      };
      return FixedColumns2;
    }()
  );
  setJQuery($);
  $.fn.dataTable.FixedColumns = FixedColumns;
  $.fn.DataTable.FixedColumns = FixedColumns;
  var apiRegister = dataTables_default.Api.register;
  apiRegister("fixedColumns()", function() {
    return this;
  });
  apiRegister("fixedColumns().start()", function(newVal) {
    var ctx = this.context[0];
    if (newVal !== void 0) {
      ctx._fixedColumns.start(newVal);
      return this;
    } else {
      return ctx._fixedColumns.start();
    }
  });
  apiRegister("fixedColumns().end()", function(newVal) {
    var ctx = this.context[0];
    if (newVal !== void 0) {
      ctx._fixedColumns.end(newVal);
      return this;
    } else {
      return ctx._fixedColumns.end();
    }
  });
  apiRegister("fixedColumns().left()", function(newVal) {
    var ctx = this.context[0];
    if (newVal !== void 0) {
      ctx._fixedColumns.left(newVal);
      return this;
    } else {
      return ctx._fixedColumns.left();
    }
  });
  apiRegister("fixedColumns().right()", function(newVal) {
    var ctx = this.context[0];
    if (newVal !== void 0) {
      ctx._fixedColumns.right(newVal);
      return this;
    } else {
      return ctx._fixedColumns.right();
    }
  });
  dataTables_default.ext.buttons.fixedColumns = {
    action: function(e, dt, node, config) {
      if ($(node).attr("active")) {
        $(node).removeAttr("active").removeClass("active");
        dt.fixedColumns().start(0);
        dt.fixedColumns().end(0);
      } else {
        $(node).attr("active", "true").addClass("active");
        dt.fixedColumns().start(config.config.start);
        dt.fixedColumns().end(config.config.end);
      }
    },
    config: {
      start: 1,
      end: 0
    },
    init: function(dt, node, config) {
      if (dt.settings()[0]._fixedColumns === void 0) {
        _init(dt.settings(), config);
      }
      $(node).attr("active", "true").addClass("active");
      dt.button(node).text(config.text || dt.i18n("buttons.fixedColumns", dt.settings()[0]._fixedColumns.c.i18n.button));
    },
    text: null
  };
  function _init(settings, options) {
    if (options === void 0) {
      options = null;
    }
    var api = new dataTables_default.Api(settings);
    var opts = options ? options : api.init().fixedColumns || dataTables_default.defaults.fixedColumns;
    var fixedColumns = new FixedColumns(api, opts);
    return fixedColumns;
  }
  $(document).on("plugin-init.dt", function(e, settings) {
    if (e.namespace !== "dt") {
      return;
    }
    if (settings.oInit.fixedColumns || dataTables_default.defaults.fixedColumns) {
      if (!settings._fixedColumns) {
        _init(settings, null);
      }
    }
  });
})();

// node_modules/datatables.net-fixedcolumns-bs5/js/fixedColumns.bootstrap5.mjs
var fixedColumns_bootstrap5_default = dataTables_bootstrap5_default;
export {
  fixedColumns_bootstrap5_default as default
};
/*! Bundled license information:

datatables.net-fixedcolumns/js/dataTables.fixedColumns.mjs:
  (*! FixedColumns 5.0.4
   * © SpryMedia Ltd - datatables.net/license
   *)

datatables.net-fixedcolumns-bs5/js/fixedColumns.bootstrap5.mjs:
  (*! Bootstrap 5 integration for DataTables' FixedColumns
   * © SpryMedia Ltd - datatables.net/license
   *)
*/
//# sourceMappingURL=datatables__net-fixedcolumns-bs5.js.map
