/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { Plugin } from '@form-validation/core';

export interface DeclarativeOptions {
    // Set it to `true` to enable the validators automatically based on the input type or particular HTML 5 attributes:
    //  -----------------+---------------------
    //  HTML 5 attribute | Equivalent validator
    //  -----------------+---------------------
    //  max="..."        | lessThan
    //  min="..."        | greaterThan
    //  maxlength="..."  | stringLength
    //  minlength="..."  | stringLength
    //  pattern="..."    | regexp
    //  required         | notEmpty
    //  type="color"     | color
    //  type="email"     | emailAddress
    //  type="range"     | between
    //  type="url"       | uri
    //  -----------------+---------------------
    // It's not enabled by default
    html5Input?: boolean;
    // The prefix of plugin declaration attributes. By default, it is set to `data-fvp-`
    pluginPrefix?: string;
    // The prefix of attributes. By default, it is set to `data-fv-`
    prefix?: string;
}

export class Declarative extends Plugin<DeclarativeOptions> {
    constructor(opts?: DeclarativeOptions);
}
