/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { type ValidateFunctionInterface, type ValidateOptions, type ValidateResult } from '@form-validation/core';

export interface EmailAddressOptions extends ValidateOptions {
    // Allow multiple email addresses, separated by a comma or semicolon; default is false.
    multiple?: boolean | string;
    // Require a global domain
    // Local domain email address will be invalid (a@b, for example)
    // This option by default is `false`
    requireGlobalDomain?: boolean;
    // Regex for character or characters expected as separator between addresses
    // default is comma /[,;]/, i.e. comma or semicolon.
    separator?: string | RegExp;
}

export function emailAddress(): ValidateFunctionInterface<EmailAddressOptions, ValidateResult>;
