/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { type ValidateFunctionInterface, type ValidateOptions, type ValidateResult } from '@form-validation/core';

export interface FileOptions extends ValidateOptions {
    // The allowed extensions, separated by a comma
    extension: string;
    // The maximum number of files
    maxFiles: number;
    // The maximum size in bytes
    maxSize: number;
    // The maximum size in bytes for all files
    maxTotalSize: number;
    // The minimum number of files
    minFiles: number;
    // The minimum size in bytes
    minSize: number;
    // The minimum size in bytes for all files
    minTotalSize: number;
    // The allowed MIME type, separated by a comma
    type: string;
}

export function file(): ValidateFunctionInterface<FileOptions, ValidateResult>;
