/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { type ValidateFunctionInterface, type ValidateOptions, type ValidateResult } from '@form-validation/core';

export interface RegexpOptions extends ValidateOptions {
    // If specified, flags can have any combination of JavaScript regular expression flags such as:
    // g: global match
    // i: ignore case
    // m: multiple line
    flags?: string;
    // The regular expression you need to check
    regexp: string | RegExp;
}

export function regexp(): ValidateFunctionInterface<RegexpOptions, ValidateResult>;
