export { SVG } from './svg/index.mjs';
export { parseSVG } from './svg/parse.mjs';
export { parseSVGStyle } from './svg/parse-style.mjs';
export { analyseSVGStructure } from './svg/analyse.mjs';
export { cleanupSVG } from './svg/cleanup.mjs';
export { removeBadAttributes } from './svg/cleanup/attribs.mjs';
export { checkBadTags } from './svg/cleanup/bad-tags.mjs';
export { cleanupRootStyle } from './svg/cleanup/root-style.mjs';
export { cleanupInlineStyle } from './svg/cleanup/inline-style.mjs';
export { cleanupSVGRoot } from './svg/cleanup/root-svg.mjs';
export { convertStyleToAttrs } from './svg/cleanup/svgo-style.mjs';
export { IconSet, blankIconSet } from './icon-set/index.mjs';
export { mergeIconSets } from './icon-set/merge.mjs';
export { addTagsToIconSet } from './icon-set/tags.mjs';
export { importFromFigma } from './import/figma/index.mjs';
export { importDirectory, importDirectorySync } from './import/directory.mjs';
export { downloadGitRepo } from './download/git/index.mjs';
export { getGitRepoHash } from './download/git/hash.mjs';
export { getGitRepoBranch } from './download/git/branch.mjs';
export { resetGitRepoContents } from './download/git/reset.mjs';
export { downloadGitHubRepo } from './download/github/index.mjs';
export { getGitHubRepoHash } from './download/github/hash.mjs';
export { downloadGitLabRepo } from './download/gitlab/index.mjs';
export { getGitLabRepoHash } from './download/gitlab/hash.mjs';
export { downloadNPMPackage } from './download/npm/index.mjs';
export { getNPMVersion, getPackageVersion } from './download/npm/version.mjs';
export { downloadPackage } from './download/index.mjs';
export { downloadFile } from './download/api/download.mjs';
export { isEmptyColor, parseColors } from './colors/parse.mjs';
export { validateColors } from './colors/validate.mjs';
export { detectIconSetPalette } from './colors/detect.mjs';
export { runSVGO } from './optimise/svgo.mjs';
export { removeFigmaClipPathFromSVG } from './optimise/figma.mjs';
export { deOptimisePaths } from './optimise/flags.mjs';
export { resetSVGOrigin } from './optimise/origin.mjs';
export { convertSVGToMask } from './optimise/mask.mjs';
export { scaleSVG } from './optimise/scale.mjs';
export { cleanupGlobalStyle } from './optimise/global-style.mjs';
export { exportToDirectory } from './export/directory.mjs';
export { exportJSONPackage } from './export/json-package.mjs';
export { exportIconPackage } from './export/icon-package.mjs';
export { writeJSONFile } from './misc/write-json.mjs';
export { prepareDirectoryForExport } from './export/helpers/prepare.mjs';
export { scanDirectory, scanDirectorySync } from './misc/scan.mjs';
export { compareDirectories } from './misc/compare-dirs.mjs';
export { unzip } from './download/helpers/unzip.mjs';
export { untar } from './download/helpers/untar.mjs';
export { execAsync } from './misc/exec.mjs';
export { cleanupIconKeyword } from './misc/keyword.mjs';
export { bumpVersion } from './misc/bump-version.mjs';
export { axiosConfig, fetchCallbacks } from './download/api/config.mjs';
export { sendAPIQuery } from './download/api/index.mjs';
export { defaultQueueParams, runConcurrentQueries } from './download/api/queue.mjs';
import 'cheerio';
import '@iconify/utils';
import './css/parse.mjs';
import './css/parser/tokens.mjs';
import './css/parser/error.mjs';
import './css/parser/strings.mjs';
import './css/parser/text.mjs';
import './css/parser/export.mjs';
import './css/parser/tree.mjs';
import './svg/data/attributes.mjs';
import './svg/data/tags.mjs';
import './svg/analyse/error.mjs';
import '@iconify/utils/lib/icon/defaults';
import '@iconify/utils/lib/svg/build';
import '@iconify/utils/lib/icon-set/minify';
import '@iconify/utils/lib/icon-set/convert-info';
import './icon-set/props.mjs';
import '@iconify/utils/lib/misc/objects';
import './icon-set/match.mjs';
import './icon-set/modified.mjs';
import './import/figma/nodes.mjs';
import './import/figma/query.mjs';
import './download/api/cache.mjs';
import 'fs';
import 'crypto';
import 'svgo';
import '@iconify/utils/lib/svg/id';
import '@iconify/utils/lib/colors';
import 'axios';
import 'pathe';
import 'fs/promises';
import 'extract-zip';
import 'tar';
import './download/gitlab/types.mjs';
import './colors/attribs.mjs';
import './optimise/unwrap.mjs';
import './export/helpers/custom-files.mjs';
import 'child_process';
